/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.dns.ZoneUpdate;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.PageImpl;
import com.microsoft.azure.management.dns.implementation.ZoneInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ZonesInner
implements InnerSupportsGet<ZoneInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ZoneInner> {
    private ZonesService service;
    private DnsManagementClientImpl client;

    public ZonesInner(Retrofit retrofit, DnsManagementClientImpl client) {
        this.service = (ZonesService)retrofit.create(ZonesService.class);
        this.client = client;
    }

    public ZoneInner createOrUpdate(String resourceGroupName, String zoneName, ZoneInner parameters) {
        return (ZoneInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters), serviceCallback);
    }

    public Observable<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters).map((Func1)new Func1<ServiceResponse<ZoneInner>, ZoneInner>(){

            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return (ZoneInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ZoneInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, ZoneInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.service.createOrUpdate(resourceGroupName, zoneName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>(){

            public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ZoneInner createOrUpdate(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        return (ZoneInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch).toBlocking().single()).body());
    }

    public ServiceFuture<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch, ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    public Observable<ZoneInner> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, zoneName, parameters, ifMatch, ifNoneMatch).map((Func1)new Func1<ServiceResponse<ZoneInner>, ZoneInner>(){

            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return (ZoneInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ZoneInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String zoneName, ZoneInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, zoneName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>(){

            public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ZoneInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ZoneInner>(){}.getType()).register(201, new TypeToken<ZoneInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String zoneName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, zoneName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String ifMatch = null;
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void delete(String resourceGroupName, String zoneName, String ifMatch) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String zoneName, String ifMatch, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String zoneName, String ifMatch) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String zoneName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String zoneName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String zoneName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String ifMatch = null;
        return this.service.beginDelete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void beginDelete(String resourceGroupName, String zoneName, String ifMatch) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String zoneName, String ifMatch, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String zoneName, String ifMatch) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ZoneInner getByResourceGroup(String resourceGroupName, String zoneName) {
        return (ZoneInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single()).body());
    }

    public ServiceFuture<ZoneInner> getByResourceGroupAsync(String resourceGroupName, String zoneName, ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    public Observable<ZoneInner> getByResourceGroupAsync(String resourceGroupName, String zoneName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, zoneName).map((Func1)new Func1<ServiceResponse<ZoneInner>, ZoneInner>(){

            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return (ZoneInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ZoneInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, zoneName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>(){

            public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ZoneInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ZoneInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ZoneInner update(String resourceGroupName, String zoneName) {
        return (ZoneInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, zoneName).toBlocking().single()).body());
    }

    public ServiceFuture<ZoneInner> updateAsync(String resourceGroupName, String zoneName, ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, zoneName), serviceCallback);
    }

    public Observable<ZoneInner> updateAsync(String resourceGroupName, String zoneName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, zoneName).map((Func1)new Func1<ServiceResponse<ZoneInner>, ZoneInner>(){

            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return (ZoneInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ZoneInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String ifMatch = null;
        Object tags = null;
        ZoneUpdate parameters = new ZoneUpdate();
        parameters.withTags(null);
        return this.service.update(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>(){

            public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ZoneInner update(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        return (ZoneInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ZoneInner> updateAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags, ServiceCallback<ZoneInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags), serviceCallback);
    }

    public Observable<ZoneInner> updateAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, zoneName, ifMatch, tags).map((Func1)new Func1<ServiceResponse<ZoneInner>, ZoneInner>(){

            public ZoneInner call(ServiceResponse<ZoneInner> response) {
                return (ZoneInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ZoneInner>> updateWithServiceResponseAsync(String resourceGroupName, String zoneName, String ifMatch, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (zoneName == null) {
            throw new IllegalArgumentException("Parameter zoneName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ZoneUpdate parameters = new ZoneUpdate();
        parameters.withTags(tags);
        return this.service.update(resourceGroupName, zoneName, this.client.subscriptionId(), ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ZoneInner>>>(){

            public Observable<ServiceResponse<ZoneInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ZonesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ZoneInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ZoneInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ZoneInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ZoneInner> listByResourceGroup(String resourceGroupName, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, top).toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listByResourceGroupAsync(String resourceGroupName, Integer top, ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listByResourceGroupAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, top).map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, Integer top) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, top).concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, Integer top) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ZoneInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ZoneInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listAsync(ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ZoneInner> list(Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(top).toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listAsync(Integer top, ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(top), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listAsync(Integer top) {
        return this.listWithServiceResponseAsync(top).map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listWithServiceResponseAsync(Integer top) {
        return this.listSinglePageAsync(top).concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listSinglePageAsync(Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ZoneInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ZoneInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ZoneInner>> serviceFuture, ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ZoneInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ZoneInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ZoneInner>((Page)response.body()){

            public Page<ZoneInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ZonesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ZoneInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ZoneInner>> serviceFuture, ListOperationCallback<ZoneInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(String nextPageLink) {
                return ZonesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ZoneInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Page<ZoneInner>>(){

            public Page<ZoneInner> call(ServiceResponse<Page<ZoneInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ZoneInner>>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(ServiceResponse<Page<ZoneInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ZonesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ZoneInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ZoneInner>>>>(){

            public Observable<ServiceResponse<Page<ZoneInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ZonesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ZoneInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ZoneInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ZonesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Body ZoneInner var4, @Header(value="If-Match") String var5, @Header(value="If-None-Match") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Header(value="If-Match") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Header(value="If-Match") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="zoneName") String var2, @Path(value="subscriptionId") String var3, @Header(value="If-Match") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ZoneUpdate var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/dnszones")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$top") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.dns.Zones listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

