/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.cdn.CdnEndpoint;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityResult;
import com.microsoft.azure.management.cdn.CustomDomainValidationResult;
import com.microsoft.azure.management.cdn.ResourceUsage;
import com.microsoft.azure.management.cdn.Sku;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.cdn.implementation.ProfileInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Map;
import java.util.Set;
import rx.Completable;
import rx.Observable;

@Fluent
public interface CdnProfile
extends GroupableResource<CdnManager, ProfileInner>,
Refreshable<CdnProfile>,
Updatable<Update> {
    public Sku sku();

    public String resourceState();

    public Map<String, CdnEndpoint> endpoints();

    @Method
    public String generateSsoUri();

    @Method
    public Observable<String> generateSsoUriAsync();

    @Method
    public ServiceFuture<String> generateSsoUriAsync(ServiceCallback<String> var1);

    public void startEndpoint(String var1);

    public Completable startEndpointAsync(String var1);

    public ServiceFuture<Void> startEndpointAsync(String var1, ServiceCallback<Void> var2);

    public void stopEndpoint(String var1);

    public Completable stopEndpointAsync(String var1);

    public ServiceFuture<Void> stopEndpointAsync(String var1, ServiceCallback<Void> var2);

    public void purgeEndpointContent(String var1, Set<String> var2);

    public Completable purgeEndpointContentAsync(String var1, Set<String> var2);

    public ServiceFuture<Void> purgeEndpointContentAsync(String var1, Set<String> var2, ServiceCallback<Void> var3);

    public void loadEndpointContent(String var1, Set<String> var2);

    public Completable loadEndpointContentAsync(String var1, Set<String> var2);

    public ServiceFuture<Void> loadEndpointContentAsync(String var1, Set<String> var2, ServiceCallback<Void> var3);

    public CustomDomainValidationResult validateEndpointCustomDomain(String var1, String var2);

    public Observable<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String var1, String var2);

    public ServiceFuture<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String var1, String var2, ServiceCallback<CustomDomainValidationResult> var3);

    public CheckNameAvailabilityResult checkEndpointNameAvailability(String var1);

    public Observable<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String var1);

    public ServiceFuture<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String var1, ServiceCallback<CheckNameAvailabilityResult> var2);

    public boolean isPremiumVerizon();

    public PagedList<ResourceUsage> listResourceUsage();

    public static interface Update
    extends Appliable<CdnProfile>,
    UpdateStages.WithEndpoint,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithEndpoint {
            public Update withNewEndpoint(String var1);

            @Beta
            public CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<Update> defineNewEndpoint();

            public CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<Update> defineNewEndpoint(String var1);

            @Beta
            public CdnEndpoint.UpdateDefinitionStages.WithStandardAttach<Update> defineNewEndpoint(String var1, String var2);

            public Update withNewPremiumEndpoint(String var1);

            @Beta
            public CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<Update> defineNewPremiumEndpoint();

            public CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<Update> defineNewPremiumEndpoint(String var1);

            @Beta
            public CdnEndpoint.UpdateDefinitionStages.WithPremiumAttach<Update> defineNewPremiumEndpoint(String var1, String var2);

            public CdnEndpoint.UpdateStandardEndpoint updateEndpoint(String var1);

            public CdnEndpoint.UpdatePremiumEndpoint updatePremiumEndpoint(String var1);

            public Update withoutEndpoint(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<CdnProfile>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithPremiumVerizonCreate
        extends WithCreate {
            public WithPremiumVerizonCreate withNewPremiumEndpoint(String var1);

            @Beta
            public CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<WithPremiumVerizonCreate> defineNewPremiumEndpoint();

            public CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<WithPremiumVerizonCreate> defineNewPremiumEndpoint(String var1);

            @Beta
            public CdnEndpoint.DefinitionStages.WithPremiumAttach<WithPremiumVerizonCreate> defineNewPremiumEndpoint(String var1, String var2);
        }

        public static interface WithStandardCreate
        extends WithCreate {
            public WithStandardCreate withNewEndpoint(String var1);

            @Beta
            public CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<WithStandardCreate> defineNewEndpoint();

            public CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<WithStandardCreate> defineNewEndpoint(String var1);

            @Beta
            public CdnEndpoint.DefinitionStages.WithStandardAttach<WithStandardCreate> defineNewEndpoint(String var1, String var2);
        }

        public static interface WithSku {
            public WithStandardCreate withStandardAkamaiSku();

            public WithStandardCreate withStandardVerizonSku();

            public WithPremiumVerizonCreate withPremiumVerizonSku();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithStandardCreate,
    DefinitionStages.WithPremiumVerizonCreate,
    DefinitionStages.WithCreate {
    }
}

