/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerValidityRecurrence
implements Serializable {
    private RecurrenceSchedule schedule;
    private ValidityInterval interval;

    public RangerValidityRecurrence() {
    }

    public RangerValidityRecurrence(RecurrenceSchedule schedule, ValidityInterval interval) {
        this.setSchedule(schedule);
        this.setInterval(interval);
    }

    public void setSchedule(RecurrenceSchedule schedule) {
        this.schedule = schedule;
    }

    public void setInterval(ValidityInterval interval) {
        this.interval = interval;
    }

    public RecurrenceSchedule getSchedule() {
        return this.schedule;
    }

    public ValidityInterval getInterval() {
        return this.interval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{RangerValidityRecurrence= {");
        sb.append(this.schedule).append(this.interval);
        sb.append(" }");
        return sb.toString();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RecurrenceSchedule {
        static final String PERMITTED_SPECIAL_CHARACTERS = "*,-";
        static final String PERMITTED_SPECIAL_CHARACTERS_FOR_MINUTES = ",";
        public static final String WILDCARD = "*";
        private String minute;
        private String hour;
        private String dayOfMonth;
        private String dayOfWeek;
        private String month;
        private String year;

        public RecurrenceSchedule() {
        }

        public RecurrenceSchedule(String minute, String hour, String dayOfMonth, String dayOfWeek, String month, String year) {
            this.setMinute(minute);
            this.setHour(hour);
            this.setDayOfMonth(dayOfMonth);
            this.setDayOfWeek(dayOfWeek);
            this.setMonth(month);
            this.setYear(year);
        }

        public String getMinute() {
            return this.minute;
        }

        public String getHour() {
            return this.hour;
        }

        public String getDayOfMonth() {
            return this.dayOfMonth;
        }

        public String getDayOfWeek() {
            return this.dayOfWeek;
        }

        public String getMonth() {
            return this.month;
        }

        public String getYear() {
            return this.year;
        }

        public void setMinute(String minute) {
            this.minute = minute;
        }

        public void setHour(String hour) {
            this.hour = hour;
        }

        public void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        public void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setFieldValue(ScheduleFieldSpec field, String value) {
            switch (field) {
                case minute: {
                    this.setMinute(value);
                    break;
                }
                case hour: {
                    this.setHour(value);
                    break;
                }
                case dayOfMonth: {
                    this.setDayOfMonth(value);
                    break;
                }
                case dayOfWeek: {
                    this.setDayOfWeek(value);
                    break;
                }
                case month: {
                    this.setMonth(value);
                    break;
                }
                case year: {
                    this.setYear(value);
                    break;
                }
            }
        }

        public String getFieldValue(ScheduleFieldSpec field) {
            switch (field) {
                case minute: {
                    return this.getMinute();
                }
                case hour: {
                    return this.getHour();
                }
                case dayOfMonth: {
                    return this.getDayOfMonth();
                }
                case dayOfWeek: {
                    return this.getDayOfWeek();
                }
                case month: {
                    return this.getMonth();
                }
                case year: {
                    return this.getYear();
                }
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" Schedule={");
            sb.append(" minute=").append(this.minute);
            sb.append(", hour=").append(this.hour);
            sb.append(", dayOfMonth=").append(this.dayOfMonth);
            sb.append(", dayOfWeek=").append(this.dayOfWeek);
            sb.append(", month=").append(this.month);
            sb.append(", year=").append(this.year);
            sb.append(" }");
            return sb.toString();
        }

        public static enum ScheduleFieldSpec {
            minute(0, 59, ","),
            hour(0, 23, "*,-"),
            dayOfMonth(1, 31, "*,-"),
            dayOfWeek(1, 7, "*,-"),
            month(0, 11, "*,-"),
            year(2017, 2100, "*,-");

            public final int minimum;
            public final int maximum;
            public final String specialChars;

            private ScheduleFieldSpec(int minimum, int maximum, String specialChars) {
                this.minimum = minimum;
                this.maximum = maximum;
                this.specialChars = specialChars;
            }
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ValidityInterval {
        private final int days;
        private final int hours;
        private final int minutes;

        public static int getValidityIntervalInMinutes(ValidityInterval interval) {
            return interval != null ? (interval.getDays() * 24 + interval.getHours()) * 60 + interval.getMinutes() : 0;
        }

        public ValidityInterval() {
            this.days = 0;
            this.hours = 0;
            this.minutes = 0;
        }

        public ValidityInterval(int days, int hours, int minutes) {
            this.days = days;
            this.hours = hours;
            this.minutes = minutes;
        }

        public int getDays() {
            return this.days;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ValidityInterval={");
            sb.append(" Interval={");
            sb.append("days=").append(this.days);
            sb.append(", hours=").append(this.hours);
            sb.append(", minutes=").append(this.minutes);
            sb.append(" }");
            return sb.toString();
        }
    }
}

