/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.keyvault.Secret;
import com.microsoft.azure.management.keyvault.Secrets;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultFutures;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManagementClientImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.keyvault.implementation.SecretImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.util.concurrent.Future;
import rx.Completable;
import rx.Observable;

@LangDefinition
class SecretsImpl
extends CreatableWrappersImpl<Secret, SecretImpl, SecretBundle>
implements Secrets {
    private final KeyVaultClient inner;
    private final Vault vault;
    private final PagedListConverter<SecretItem, Secret> itemConverter = new PagedListConverter<SecretItem, Secret>(){

        public Observable<Secret> typeConvertAsync(SecretItem inner) {
            return Observable.just((Object)SecretsImpl.this.wrapModel(inner));
        }
    };

    SecretsImpl(KeyVaultClient client, Vault vault) {
        this.inner = client;
        this.vault = vault;
    }

    public SecretImpl define(String name) {
        return this.wrapModel(name);
    }

    protected SecretImpl wrapModel(String name) {
        return new SecretImpl(name, new SecretBundle(), this.vault);
    }

    public Secret getById(String id) {
        return this.wrapModel(this.inner.getSecret(id));
    }

    public Observable<Secret> getByIdAsync(String id) {
        return Observable.from(this.getByIdAsync(id, null));
    }

    public ServiceFuture<Secret> getByIdAsync(final String id, ServiceCallback<Secret> callback) {
        return new KeyVaultFutures.ServiceFutureConverter<SecretBundle, Secret>(){

            @Override
            protected ServiceFuture<SecretBundle> callAsync() {
                return SecretsImpl.this.inner.getSecretAsync(id, null);
            }

            @Override
            protected Secret wrapModel(SecretBundle secretBundle) {
                return SecretsImpl.this.wrapModel(secretBundle);
            }
        }.toFuture(callback);
    }

    protected SecretImpl wrapModel(SecretBundle inner) {
        if (inner == null) {
            return null;
        }
        return new SecretImpl(inner.secretIdentifier().name(), inner, this.vault);
    }

    private SecretImpl wrapModel(SecretItem inner) {
        if (inner == null) {
            return null;
        }
        SerializerAdapter serializer = ((KeyVaultManagementClientImpl)((Object)((KeyVaultManager)((Object)this.vault.manager())).inner())).restClient().serializerAdapter();
        try {
            return this.wrapModel((SecretBundle)serializer.deserialize(serializer.serialize((Object)inner), SecretBundle.class));
        }
        catch (IOException e) {
            return null;
        }
    }

    public Completable deleteByIdAsync(String id) {
        SecretIdentifier identifier = new SecretIdentifier(id);
        return Completable.fromFuture((Future)this.inner.deleteSecretAsync(identifier.vault(), identifier.name(), null));
    }

    public PagedList<Secret> list() {
        return this.itemConverter.convert(this.inner.listSecrets(this.vault.vaultUri()));
    }

    public Observable<Secret> listAsync() {
        return new KeyVaultFutures.ListCallbackObserver<SecretItem, Secret>(){

            @Override
            protected void list(ListOperationCallback<SecretItem> callback) {
                SecretsImpl.this.inner.listSecretsAsync(SecretsImpl.this.vault.vaultUri(), callback);
            }

            @Override
            protected Observable<Secret> typeConvertAsync(SecretItem secretItem) {
                return Observable.just((Object)SecretsImpl.this.wrapModel(secretItem));
            }
        }.toObservable();
    }

    public Observable<Secret> getByNameAsync(final String name) {
        return new KeyVaultFutures.ServiceFutureConverter<SecretBundle, Secret>(){

            @Override
            ServiceFuture<SecretBundle> callAsync() {
                return SecretsImpl.this.inner.getSecretAsync(SecretsImpl.this.vault.vaultUri(), name, null);
            }

            @Override
            Secret wrapModel(SecretBundle o) {
                return null;
            }
        }.toObservable();
    }

    public Secret getByName(String name) {
        return this.wrapModel(this.inner.getSecret(this.vault.vaultUri(), name));
    }

    @Override
    public Secret getByNameAndVersion(String name, String version) {
        return this.wrapModel(this.inner.getSecret(this.vault.vaultUri(), name, version));
    }

    @Override
    public Observable<Secret> getByNameAndVersionAsync(final String name, final String version) {
        return new KeyVaultFutures.ServiceFutureConverter<SecretBundle, Secret>(){

            @Override
            ServiceFuture<SecretBundle> callAsync() {
                return SecretsImpl.this.inner.getSecretAsync(SecretsImpl.this.vault.vaultUri(), name, version, null);
            }

            @Override
            Secret wrapModel(SecretBundle o) {
                return null;
            }
        }.toObservable();
    }
}

