/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayBackend;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayPathRule;
import com.microsoft.azure.management.network.ApplicationGatewayRedirectConfiguration;
import com.microsoft.azure.management.network.ApplicationGatewayUrlPathMap;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayPathRuleInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayUrlPathMapImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@LangDefinition
class ApplicationGatewayPathRuleImpl
extends ChildResourceImpl<ApplicationGatewayPathRuleInner, ApplicationGatewayUrlPathMapImpl, ApplicationGatewayUrlPathMap>
implements ApplicationGatewayPathRule,
ApplicationGatewayPathRule.Definition<ApplicationGatewayUrlPathMap.DefinitionStages.WithAttach<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate>>,
ApplicationGatewayPathRule.UpdateDefinition<ApplicationGatewayUrlPathMap.UpdateDefinitionStages.WithAttach<ApplicationGateway.Update>>,
ApplicationGatewayPathRule.Update {
    ApplicationGatewayPathRuleImpl(ApplicationGatewayPathRuleInner inner, ApplicationGatewayUrlPathMapImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((ApplicationGatewayPathRuleInner)((Object)this.inner())).name();
    }

    public ApplicationGatewayUrlPathMapImpl attach() {
        return ((ApplicationGatewayUrlPathMapImpl)this.parent()).withPathRule(this);
    }

    public ApplicationGatewayPathRuleImpl toBackendHttpConfiguration(String name) {
        SubResource httpConfigRef = new SubResource().withId(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).futureResourceId() + "/backendHttpSettingsCollection/" + name);
        ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withBackendHttpSettings(httpConfigRef);
        return this;
    }

    public ApplicationGatewayPathRuleImpl toBackend(String name) {
        ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withBackendAddressPool(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).ensureBackendRef(name));
        return this;
    }

    public ApplicationGatewayPathRuleImpl withRedirectConfiguration(String name) {
        if (name == null) {
            ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withRedirectConfiguration(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).futureResourceId() + "/redirectConfigurations/" + name);
            ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withRedirectConfiguration(ref);
        }
        return this;
    }

    @Override
    public ApplicationGatewayBackend backend() {
        SubResource backendRef = ((ApplicationGatewayPathRuleInner)((Object)this.inner())).backendAddressPool();
        if (backendRef != null) {
            String backendName = ResourceUtils.nameFromResourceId((String)backendRef.id());
            return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).backends().get(backendName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfiguration backendHttpConfiguration() {
        SubResource configRef = ((ApplicationGatewayPathRuleInner)((Object)this.inner())).backendHttpSettings();
        if (configRef != null) {
            String configName = ResourceUtils.nameFromResourceId((String)configRef.id());
            return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).backendHttpConfigurations().get(configName);
        }
        return null;
    }

    @Override
    public ApplicationGatewayRedirectConfiguration redirectConfiguration() {
        SubResource ref = ((ApplicationGatewayPathRuleInner)((Object)this.inner())).redirectConfiguration();
        if (ref == null) {
            return null;
        }
        return ((ApplicationGatewayImpl)((ApplicationGatewayUrlPathMapImpl)this.parent()).parent()).redirectConfigurations().get(ResourceUtils.nameFromResourceId((String)ref.id()));
    }

    @Override
    public List<String> paths() {
        return Collections.unmodifiableList(((ApplicationGatewayPathRuleInner)((Object)this.inner())).paths());
    }

    public ApplicationGatewayPathRuleImpl withPath(String path) {
        if (((ApplicationGatewayPathRuleInner)((Object)this.inner())).paths() == null) {
            ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withPaths(new ArrayList<String>());
        }
        ((ApplicationGatewayPathRuleInner)((Object)this.inner())).paths().add(path);
        return this;
    }

    public ApplicationGatewayPathRuleImpl withPaths(String ... paths) {
        ((ApplicationGatewayPathRuleInner)((Object)this.inner())).withPaths(Arrays.asList(paths));
        return this;
    }
}

