/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.search.CheckNameAvailabilityInput;
import com.microsoft.azure.management.search.implementation.CheckNameAvailabilityOutputInner;
import com.microsoft.azure.management.search.implementation.PageImpl;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchManagementRequestOptionsInner;
import com.microsoft.azure.management.search.implementation.SearchServiceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServicesInner
implements InnerSupportsGet<SearchServiceInner>,
InnerSupportsDelete<Void> {
    private ServicesService service;
    private SearchManagementClientImpl client;

    public ServicesInner(Retrofit retrofit, SearchManagementClientImpl client) {
        this.service = (ServicesService)retrofit.create(ServicesService.class);
        this.client = client;
    }

    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner service) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service).toBlocking().last()).body());
    }

    public ServiceFuture<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service), serviceCallback);
    }

    public Observable<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner searchServiceInner) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (searchServiceInner == null) {
            throw new IllegalArgumentException("Parameter service is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)searchServiceInner));
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, searchServiceName, this.client.subscriptionId(), searchServiceInner, this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SearchServiceInner>(){}.getType());
    }

    public SearchServiceInner createOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions).toBlocking().last()).body());
    }

    public ServiceFuture<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<SearchServiceInner> createOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner searchServiceInner, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (searchServiceInner == null) {
            throw new IllegalArgumentException("Parameter service is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)searchServiceInner));
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, searchServiceName, this.client.subscriptionId(), searchServiceInner, this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SearchServiceInner>(){}.getType());
    }

    public SearchServiceInner beginCreateOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner service) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service).toBlocking().single()).body());
    }

    public ServiceFuture<SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service), serviceCallback);
    }

    public Observable<SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner searchServiceInner) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (searchServiceInner == null) {
            throw new IllegalArgumentException("Parameter service is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)searchServiceInner));
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.beginCreateOrUpdate(resourceGroupName, searchServiceName, this.client.subscriptionId(), searchServiceInner, this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SearchServiceInner>>>(){

            public Observable<ServiceResponse<SearchServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SearchServiceInner beginCreateOrUpdate(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions).toBlocking().single()).body());
    }

    public ServiceFuture<SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<SearchServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String searchServiceName, SearchServiceInner service, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, searchServiceName, service, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchServiceInner searchServiceInner, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (searchServiceInner == null) {
            throw new IllegalArgumentException("Parameter service is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)searchServiceInner));
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.beginCreateOrUpdate(resourceGroupName, searchServiceName, this.client.subscriptionId(), searchServiceInner, this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SearchServiceInner>>>(){

            public Observable<ServiceResponse<SearchServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SearchServiceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SearchServiceInner>(){}.getType()).register(201, new TypeToken<SearchServiceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SearchServiceInner getByResourceGroup(String resourceGroupName, String searchServiceName) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName).toBlocking().single()).body());
    }

    public ServiceFuture<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName), serviceCallback);
    }

    public Observable<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String searchServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.getByResourceGroup(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SearchServiceInner>>>(){

            public Observable<ServiceResponse<SearchServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SearchServiceInner getByResourceGroup(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (SearchServiceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).toBlocking().single()).body());
    }

    public ServiceFuture<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<SearchServiceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<SearchServiceInner> getByResourceGroupAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<SearchServiceInner>, SearchServiceInner>(){

            public SearchServiceInner call(ServiceResponse<SearchServiceInner> response) {
                return (SearchServiceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SearchServiceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.getByResourceGroup(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SearchServiceInner>>>(){

            public Observable<ServiceResponse<SearchServiceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SearchServiceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SearchServiceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String searchServiceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String searchServiceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String searchServiceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String searchServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.delete(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void delete(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.delete(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SearchServiceInner> listByResourceGroup(String resourceGroupName) {
        return (List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SearchServiceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<SearchServiceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<List<SearchServiceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<SearchServiceInner>>, List<SearchServiceInner>>(){

            public List<SearchServiceInner> call(ServiceResponse<List<SearchServiceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SearchServiceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SearchServiceInner>>>>(){

            public Observable<ServiceResponse<List<SearchServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<SearchServiceInner> listByResourceGroup(String resourceGroupName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<List<SearchServiceInner>> listByResourceGroupAsync(String resourceGroupName, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<List<SearchServiceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<List<SearchServiceInner>> listByResourceGroupAsync(String resourceGroupName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<List<SearchServiceInner>>, List<SearchServiceInner>>(){

            public List<SearchServiceInner> call(ServiceResponse<List<SearchServiceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SearchServiceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SearchServiceInner>>>>(){

            public Observable<ServiceResponse<List<SearchServiceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServicesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SearchServiceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SearchServiceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CheckNameAvailabilityOutputInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityOutputInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityOutputInner>, CheckNameAvailabilityOutputInner>(){

            public CheckNameAvailabilityOutputInner call(ServiceResponse<CheckNameAvailabilityOutputInner> response) {
                return (CheckNameAvailabilityOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, checkNameAvailabilityInput, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityOutputInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CheckNameAvailabilityOutputInner checkNameAvailability(String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (CheckNameAvailabilityOutputInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<CheckNameAvailabilityOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityOutputInner>, CheckNameAvailabilityOutputInner>(){

            public CheckNameAvailabilityOutputInner call(ServiceResponse<CheckNameAvailabilityOutputInner> response) {
                return (CheckNameAvailabilityOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithServiceResponseAsync(String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, checkNameAvailabilityInput, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityOutputInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServicesInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityOutputInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityOutputInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Body SearchServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-client-request-id") UUID var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Body SearchServiceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-client-request-id") UUID var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-client-request-id") UUID var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-client-request-id") UUID var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-client-request-id") UUID var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.Services checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Search/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-client-request-id") UUID var4, @Body CheckNameAvailabilityInput var5, @Header(value="User-Agent") String var6);
    }
}

