/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.search.AdminKeyKind;
import com.microsoft.azure.management.search.implementation.AdminKeyResultInner;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchManagementRequestOptionsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class AdminKeysInner {
    private AdminKeysService service;
    private SearchManagementClientImpl client;

    public AdminKeysInner(Retrofit retrofit, SearchManagementClientImpl client) {
        this.service = (AdminKeysService)retrofit.create(AdminKeysService.class);
        this.client = client;
    }

    public AdminKeyResultInner get(String resourceGroupName, String searchServiceName) {
        return (AdminKeyResultInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, searchServiceName).toBlocking().single()).body();
    }

    public ServiceFuture<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName, ServiceCallback<AdminKeyResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, searchServiceName), serviceCallback);
    }

    public Observable<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, searchServiceName).map((Func1)new Func1<ServiceResponse<AdminKeyResultInner>, AdminKeyResultInner>(){

            public AdminKeyResultInner call(ServiceResponse<AdminKeyResultInner> response) {
                return (AdminKeyResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AdminKeyResultInner>> getWithServiceResponseAsync(String resourceGroupName, String searchServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.get(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AdminKeyResultInner>>>(){

            public Observable<ServiceResponse<AdminKeyResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AdminKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public AdminKeyResultInner get(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (AdminKeyResultInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<AdminKeyResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.getWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<AdminKeyResultInner>, AdminKeyResultInner>(){

            public AdminKeyResultInner call(ServiceResponse<AdminKeyResultInner> response) {
                return (AdminKeyResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AdminKeyResultInner>> getWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.get(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AdminKeyResultInner>>>(){

            public Observable<ServiceResponse<AdminKeyResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AdminKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AdminKeyResultInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AdminKeyResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AdminKeyResultInner regenerate(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return (AdminKeyResultInner)((ServiceResponse)this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind).toBlocking().single()).body();
    }

    public ServiceFuture<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, ServiceCallback<AdminKeyResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind), serviceCallback);
    }

    public Observable<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind).map((Func1)new Func1<ServiceResponse<AdminKeyResultInner>, AdminKeyResultInner>(){

            public AdminKeyResultInner call(ServiceResponse<AdminKeyResultInner> response) {
                return (AdminKeyResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AdminKeyResultInner>> regenerateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.regenerate(resourceGroupName, searchServiceName, keyKind, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AdminKeyResultInner>>>(){

            public Observable<ServiceResponse<AdminKeyResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AdminKeysInner.this.regenerateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public AdminKeyResultInner regenerate(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (AdminKeyResultInner)((ServiceResponse)this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<AdminKeyResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.regenerateWithServiceResponseAsync(resourceGroupName, searchServiceName, keyKind, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<AdminKeyResultInner>, AdminKeyResultInner>(){

            public AdminKeyResultInner call(ServiceResponse<AdminKeyResultInner> response) {
                return (AdminKeyResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AdminKeyResultInner>> regenerateWithServiceResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (keyKind == null) {
            throw new IllegalArgumentException("Parameter keyKind is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.regenerate(resourceGroupName, searchServiceName, keyKind, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AdminKeyResultInner>>>(){

            public Observable<ServiceResponse<AdminKeyResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AdminKeysInner.this.regenerateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AdminKeyResultInner> regenerateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AdminKeyResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AdminKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.AdminKeys get"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listAdminKeys")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-client-request-id") UUID var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.AdminKeys regenerate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/regenerateAdminKey/{keyKind}")
        public Observable<Response<ResponseBody>> regenerate(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="keyKind") AdminKeyKind var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-client-request-id") UUID var7, @Header(value="User-Agent") String var8);
    }
}

