/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KQueueSupport {
    private static final Logger LOG = LoggerFactory.getLogger(KQueueSupport.class);
    public static final String NAME = "KQUEUE";

    public static boolean isAvailable(TransportOptions transportOptions) {
        try {
            return transportOptions.allowNativeIO() && KQueue.isAvailable();
        }
        catch (NoClassDefFoundError ncdfe) {
            LOG.debug("Unable to check for KQueue support due to missing class definition", (Throwable)ncdfe);
            return false;
        }
    }

    public static EventLoopGroup createGroup(int nThreads, ThreadFactory ioThreadFactory) {
        return new KQueueEventLoopGroup(nThreads, ioThreadFactory);
    }

    public static Class<? extends Channel> getChannelClass() {
        return KQueueSocketChannel.class;
    }
}

