/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class QueueMappingRecord
implements Record {
    private final UUID _id;
    private final String _name;

    QueueMappingRecord(UUID id, String name) {
        this._id = id;
        this._name = name;
    }

    @Override
    public RecordType getType() {
        return RecordType.QUEUE_MAPPING;
    }

    public UUID getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public void writeData(Serializer output) throws IOException {
        byte[] nameBytes = this._name.getBytes(StandardCharsets.UTF_8);
        output.writeLong(this._id.getMostSignificantBits());
        output.writeLong(this._id.getLeastSignificantBits());
        output.writeInt(nameBytes.length);
        output.write(nameBytes);
    }

    public static QueueMappingRecord read(Deserializer deserializer) throws IOException {
        UUID id = deserializer.readUUID();
        int nameLength = deserializer.readInt();
        byte[] nameBytes = deserializer.readBytes(nameLength);
        return new QueueMappingRecord(id, new String(nameBytes, StandardCharsets.UTF_8));
    }
}

