/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerMethodProcessor;

public class ConnectionOpenBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 40;
    private final AMQShortString _virtualHost;
    private final AMQShortString _capabilities;
    private final boolean _insist;

    public ConnectionOpenBody(AMQShortString virtualHost, AMQShortString capabilities, boolean insist) {
        this._virtualHost = virtualHost;
        this._capabilities = capabilities;
        this._insist = insist;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    public final AMQShortString getVirtualHost() {
        return this._virtualHost;
    }

    public final AMQShortString getCapabilities() {
        return this._capabilities;
    }

    public final boolean getInsist() {
        return this._insist;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        size += this.getSizeOf(this._virtualHost);
        return size += this.getSizeOf(this._capabilities);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._virtualHost);
        this.writeAMQShortString(buffer, this._capabilities);
        this.writeBitfield(buffer, this._insist ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionOpen(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionOpenBodyImpl: ");
        buf.append("virtualHost=");
        buf.append(this.getVirtualHost());
        buf.append(", ");
        buf.append("capabilities=");
        buf.append(this.getCapabilities());
        buf.append(", ");
        buf.append("insist=");
        buf.append(this.getInsist());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerMethodProcessor dispatcher) {
        boolean insist;
        AMQShortString virtualHost = AMQShortString.readAMQShortString(buffer);
        AMQShortString capabilities = AMQShortString.readAMQShortString(buffer);
        boolean bl = insist = (buffer.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionOpen(virtualHost, capabilities, insist);
        }
    }
}

