/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class SaslConstants {
    static final String PLUGIN_NAME = "sasl";
    public static final String JAAS_BOOKIE_SECTION_NAME = "saslJaasBookieSectionName";
    public static final String JAAS_DEFAULT_BOOKIE_SECTION_NAME = "Bookie";
    public static final String JAAS_AUDITOR_SECTION_NAME = "saslJaasAuditorSectionName";
    public static final String JAAS_DEFAULT_AUDITOR_SECTION_NAME = "Auditor";
    public static final String JAAS_CLIENT_SECTION_NAME = "saslJaasClientSectionName";
    public static final String JAAS_DEFAULT_CLIENT_SECTION_NAME = "BookKeeper";
    public static final String JAAS_CLIENT_ALLOWED_IDS = "saslJaasClientAllowedIds";
    public static final String JAAS_CLIENT_ALLOWED_IDS_DEFAULT = ".*bookkeeper.*";
    static final String KINIT_COMMAND_DEFAULT = "/usr/bin/kinit";
    static final String KINIT_COMMAND = "kerberos.kinit";
    static final String SASL_BOOKKEEPER_PROTOCOL = "bookkeeper";
    static final String SASL_BOOKKEEPER_REALM = "bookkeeper";
    static final String SASL_SERVICE_NAME = "bookkeeper.sasl.servicename";
    static final String SASL_SERVICE_NAME_DEFAULT = "bookkeeper";
    static final String SASL_MD5_DUMMY_HOSTNAME = "bookkeeper";

    static boolean isUsingTicketCache(String configurationEntry) {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(configurationEntry);
        if (entries == null) {
            return false;
        }
        for (AppConfigurationEntry entry : entries) {
            String val;
            if (entry.getOptions().get("useTicketCache") == null || !(val = (String)entry.getOptions().get("useTicketCache")).equals("true")) continue;
            return true;
        }
        return false;
    }

    static String getPrincipal(String configurationEntry) {
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(configurationEntry);
        if (entries == null) {
            return null;
        }
        for (AppConfigurationEntry entry : entries) {
            if (entry.getOptions().get("principal") == null) continue;
            return (String)entry.getOptions().get("principal");
        }
        return null;
    }
}

