/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ToLongFunction;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.util.FutureUtil;

public abstract class AbstractSubscription
implements Subscription {
    protected final LongAdder bytesOutFromRemovedConsumers = new LongAdder();
    protected final LongAdder msgOutFromRemovedConsumer = new LongAdder();

    public long getMsgOutCounter() {
        return this.msgOutFromRemovedConsumer.longValue() + this.sumConsumers(Consumer::getMsgOutCounter);
    }

    public long getBytesOutCounter() {
        return this.bytesOutFromRemovedConsumers.longValue() + this.sumConsumers(Consumer::getBytesOutCounter);
    }

    private long sumConsumers(ToLongFunction<Consumer> toCounter) {
        return Optional.ofNullable(this.getDispatcher()).map(dispatcher -> dispatcher.getConsumers().stream().mapToLong(toCounter).sum()).orElse(0L);
    }

    protected Optional<CompletableFuture<Void>> checkForConsumerCompatibilityErrorWithDispatcher(Dispatcher dispatcher, Consumer consumer) {
        if (consumer.subType() != dispatcher.getType()) {
            return Optional.of(FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionBusyException(String.format("Subscription is of different type. Active subscription type of '%s' is different than the connecting consumer's type '%s'.", dispatcher.getType(), consumer.subType()))));
        }
        if (dispatcher.getType() == CommandSubscribe.SubType.Key_Shared) {
            KeySharedMeta dispatcherKsm = dispatcher.getConsumers().get(0).getKeySharedMeta();
            KeySharedMeta consumerKsm = consumer.getKeySharedMeta();
            if (dispatcherKsm.getKeySharedMode() != consumerKsm.getKeySharedMode()) {
                return Optional.of(FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionBusyException(String.format("Subscription is of different type. Active subscription key_shared mode of '%s' is different than the connecting consumer's key_shared mode '%s'.", dispatcherKsm.getKeySharedMode(), consumerKsm.getKeySharedMode()))));
            }
            if (dispatcherKsm.isAllowOutOfOrderDelivery() != consumerKsm.isAllowOutOfOrderDelivery()) {
                return Optional.of(FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionBusyException(String.format("Subscription is of different type. %s", dispatcherKsm.isAllowOutOfOrderDelivery() ? "Active subscription allows out of order delivery while the connecting consumer does not allow it." : "Active subscription does not allow out of order delivery while the connecting consumer allows it."))));
            }
        }
        return Optional.empty();
    }
}

