/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDoubleAssociativeContainer;
import com.carrotsearch.hppc.CharDoubleHashMap;
import com.carrotsearch.hppc.CharDoubleMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.comparators.CharComparator;
import com.carrotsearch.hppc.comparators.CharDoubleComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharDoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.CharDoublePredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.CharDoubleProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharDoubleHashMap
implements CharDoubleMap {
    public final CharDoubleHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharDoubleHashMap(CharDoubleHashMap delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharDoubleHashMap(CharDoubleHashMap delegate, CharDoubleComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharDoubleComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final double[] values;
            {
                this.keys = SortedIterationCharDoubleHashMap.this.delegate.keys;
                this.values = SortedIterationCharDoubleHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharDoubleCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharDoublePredicate predicate) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharDoublePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public double get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public double getOrDefault(char key, double defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public double put(char key, double value) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharDoubleAssociativeContainer container) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharDoubleCursor> iterable) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public double putOrAdd(char key, double putValue, double incrementValue) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public double addTo(char key, double additionValue) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public double remove(char key) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public double indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public double indexReplace(int index, double newValue) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, double value) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public double indexRemove(int index) {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharDoubleHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        private final CharDoubleCursor cursor = new CharDoubleCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharDoubleCursor fetch() {
            if (this.index < SortedIterationCharDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharDoubleHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharDoubleCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharDoubleHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharDoubleHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final SortedIterationCharDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (CharDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.index < SortedIterationCharDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharDoubleHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

