/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="bookie", category="server", help="Entry location index stats")
class EntryLocationIndexStats {
    private static final String ENTRIES_COUNT = "entries-count";
    private static final String LOOKUP_ENTRY_LOCATION = "lookup-entry-location";
    @StatsDoc(name="entries-count", help="Current number of entries")
    private final Gauge<Long> entriesCountGauge;
    @StatsDoc(name="lookup-entry-location", help="operation stats of looking up entry location")
    private final OpStatsLogger lookupEntryLocationStats;

    EntryLocationIndexStats(StatsLogger statsLogger, final Supplier<Long> entriesCountSupplier) {
        this.entriesCountGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return 0L;
            }

            public Long getSample() {
                return (Long)entriesCountSupplier.get();
            }
        };
        statsLogger.registerGauge(ENTRIES_COUNT, this.entriesCountGauge);
        this.lookupEntryLocationStats = statsLogger.getOpStatsLogger(LOOKUP_ENTRY_LOCATION);
    }

    public Gauge<Long> getEntriesCountGauge() {
        return this.entriesCountGauge;
    }

    public OpStatsLogger getLookupEntryLocationStats() {
        return this.lookupEntryLocationStats;
    }
}

