/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.JmxMBeanPropertyCache;
import io.prometheus.jmx.OptionalValueExtractor;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

class JmxScraper {
    private static final Logger logger = Logger.getLogger(JmxScraper.class.getName());
    private final MBeanReceiver receiver;
    private final String jmxUrl;
    private final String username;
    private final String password;
    private final boolean ssl;
    private final List<ObjectName> whitelistObjectNames;
    private final List<ObjectName> blacklistObjectNames;
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache;
    private final OptionalValueExtractor optionalValueExtractor = new OptionalValueExtractor();

    public JmxScraper(String jmxUrl, String username, String password, boolean ssl, List<ObjectName> whitelistObjectNames, List<ObjectName> blacklistObjectNames, MBeanReceiver receiver, JmxMBeanPropertyCache jmxMBeanPropertyCache) {
        this.jmxUrl = jmxUrl;
        this.receiver = receiver;
        this.username = username;
        this.password = password;
        this.ssl = ssl;
        this.whitelistObjectNames = whitelistObjectNames;
        this.blacklistObjectNames = blacklistObjectNames;
        this.jmxMBeanPropertyCache = jmxMBeanPropertyCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScrape() throws Exception {
        MBeanServerConnection beanConn;
        JMXConnector jmxc = null;
        if (this.jmxUrl.isEmpty()) {
            beanConn = ManagementFactory.getPlatformMBeanServer();
        } else {
            HashMap<String, Object> environment = new HashMap<String, Object>();
            if (this.username != null && this.username.length() != 0 && this.password != null && this.password.length() != 0) {
                String[] credent = new String[]{this.username, this.password};
                environment.put("jmx.remote.credentials", credent);
            }
            if (this.ssl) {
                environment.put("java.naming.security.protocol", "ssl");
                SslRMIClientSocketFactory clientSocketFactory = new SslRMIClientSocketFactory();
                environment.put("jmx.remote.rmi.client.socket.factory", clientSocketFactory);
                environment.put("com.sun.jndi.rmi.factory.socket", clientSocketFactory);
            }
            jmxc = JMXConnectorFactory.connect(new JMXServiceURL(this.jmxUrl), environment);
            beanConn = jmxc.getMBeanServerConnection();
        }
        try {
            HashSet<ObjectName> mBeanNames = new HashSet<ObjectName>();
            for (ObjectName name : this.whitelistObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.add(instance.getObjectName());
                }
            }
            for (ObjectName name : this.blacklistObjectNames) {
                for (ObjectInstance instance : beanConn.queryMBeans(name, null)) {
                    mBeanNames.remove(instance.getObjectName());
                }
            }
            this.jmxMBeanPropertyCache.onlyKeepMBeans(mBeanNames);
            for (ObjectName objectName : mBeanNames) {
                long start = System.nanoTime();
                this.scrapeBean(beanConn, objectName);
                logger.fine("TIME: " + (System.nanoTime() - start) + " ns for " + objectName.toString());
            }
        }
        finally {
            if (jmxc != null) {
                jmxc.close();
            }
        }
    }

    private void scrapeBean(MBeanServerConnection beanConn, ObjectName mbeanName) {
        AttributeList attributes;
        MBeanInfo info;
        try {
            info = beanConn.getMBeanInfo(mbeanName);
        }
        catch (IOException e) {
            JmxScraper.logScrape(mbeanName.toString(), "getMBeanInfo Fail: " + e);
            return;
        }
        catch (JMException e) {
            JmxScraper.logScrape(mbeanName.toString(), "getMBeanInfo Fail: " + e);
            return;
        }
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        LinkedHashMap<String, MBeanAttributeInfo> name2AttrInfo = new LinkedHashMap<String, MBeanAttributeInfo>();
        for (int idx = 0; idx < attrInfos.length; ++idx) {
            MBeanAttributeInfo attr = attrInfos[idx];
            if (!attr.isReadable()) {
                JmxScraper.logScrape(mbeanName, attr, "not readable");
                continue;
            }
            name2AttrInfo.put(attr.getName(), attr);
        }
        try {
            attributes = beanConn.getAttributes(mbeanName, name2AttrInfo.keySet().toArray(new String[0]));
            if (attributes == null) {
                JmxScraper.logScrape(mbeanName.toString(), "getAttributes Fail: attributes are null");
                return;
            }
        }
        catch (Exception e) {
            JmxScraper.logScrape(mbeanName, name2AttrInfo.keySet(), "Fail: " + e);
            return;
        }
        for (Attribute attributeObj : attributes.asList()) {
            if (!Attribute.class.isInstance(attributeObj)) continue;
            Attribute attribute = attributeObj;
            MBeanAttributeInfo attr = (MBeanAttributeInfo)name2AttrInfo.get(attribute.getName());
            JmxScraper.logScrape(mbeanName, attr, "process");
            this.processBeanValue(mbeanName.getDomain(), this.jmxMBeanPropertyCache.getKeyPropertyList(mbeanName), new LinkedList<String>(), attr.getName(), attr.getType(), attr.getDescription(), attribute.getValue());
        }
    }

    private void processBeanValue(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
        if (value == null) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "null");
        } else if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            if (value instanceof Date) {
                attrType = "java.lang.Double";
                value = (double)((Date)value).getTime() / 1000.0;
            }
            JmxScraper.logScrape(domain + beanProperties + attrName, value.toString());
            this.receiver.recordBean(domain, beanProperties, attrKeys, attrName, attrType, attrDescription, value);
        } else if (value instanceof CompositeData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "compositedata");
            CompositeData composite = (CompositeData)value;
            CompositeType type = composite.getCompositeType();
            attrKeys = new LinkedList<String>(attrKeys);
            attrKeys.add(attrName);
            for (String key : type.keySet()) {
                String typ = type.getType(key).getTypeName();
                Object valu = composite.get(key);
                this.processBeanValue(domain, beanProperties, attrKeys, key, typ, type.getDescription(), valu);
            }
        } else if (value instanceof TabularData) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "tabulardata");
            TabularData tds = (TabularData)value;
            TabularType tt = tds.getTabularType();
            List<String> rowKeys = tt.getIndexNames();
            CompositeType type = tt.getRowType();
            TreeSet<String> valueKeys = new TreeSet<String>(type.keySet());
            valueKeys.removeAll(rowKeys);
            LinkedList<String> extendedAttrKeys = new LinkedList<String>(attrKeys);
            extendedAttrKeys.add(attrName);
            for (Object valu : tds.values()) {
                if (valu instanceof CompositeData) {
                    CompositeData composite = (CompositeData)valu;
                    LinkedHashMap<String, String> l2s = new LinkedHashMap<String, String>(beanProperties);
                    for (String idx : rowKeys) {
                        Object obj = composite.get(idx);
                        if (obj == null) continue;
                        while (l2s.containsKey(idx)) {
                            idx = idx + "_";
                        }
                        l2s.put(idx, obj.toString());
                    }
                    for (String valueIdx : valueKeys) {
                        LinkedList<String> attrNames = extendedAttrKeys;
                        String typ = type.getType(valueIdx).getTypeName();
                        String name = valueIdx;
                        if (valueIdx.toLowerCase().equals("value")) {
                            attrNames = attrKeys;
                            name = attrName;
                        }
                        this.processBeanValue(domain, l2s, attrNames, name, typ, type.getDescription(), composite.get(valueIdx));
                    }
                    continue;
                }
                JmxScraper.logScrape(domain, "not a correct tabulardata format");
            }
        } else if (value.getClass().isArray()) {
            JmxScraper.logScrape(domain, "arrays are unsupported");
        } else if (this.optionalValueExtractor.isOptional(value)) {
            JmxScraper.logScrape(domain + beanProperties + attrName, "java.util.Optional");
            this.processBeanValue(domain, beanProperties, attrKeys, attrName, attrType, attrDescription, this.optionalValueExtractor.getOptionalValueOrNull(value));
        } else {
            JmxScraper.logScrape(domain + beanProperties, attrType + " is not exported");
        }
    }

    private static void logScrape(ObjectName mbeanName, Set<String> names, String msg) {
        JmxScraper.logScrape(mbeanName + "_" + names, msg);
    }

    private static void logScrape(ObjectName mbeanName, MBeanAttributeInfo attr, String msg) {
        JmxScraper.logScrape(mbeanName + "'_'" + attr.getName(), msg);
    }

    private static void logScrape(String name, String msg) {
        logger.log(Level.FINE, "scrape: '" + name + "': " + msg);
    }

    public static void main(String[] args) throws Exception {
        LinkedList<ObjectName> objectNames = new LinkedList<ObjectName>();
        objectNames.add(null);
        if (args.length >= 3) {
            new JmxScraper(args[0], args[1], args[2], false, objectNames, new LinkedList<ObjectName>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        } else if (args.length > 0) {
            new JmxScraper(args[0], "", "", false, objectNames, new LinkedList<ObjectName>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        } else {
            new JmxScraper("", "", "", false, objectNames, new LinkedList<ObjectName>(), new StdoutWriter(), new JmxMBeanPropertyCache()).doScrape();
        }
    }

    private static class StdoutWriter
    implements MBeanReceiver {
        private StdoutWriter() {
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object value) {
            System.out.println(domain + beanProperties + attrKeys + attrName + ": " + value);
        }
    }

    public static interface MBeanReceiver {
        public void recordBean(String var1, LinkedHashMap<String, String> var2, LinkedList<String> var3, String var4, String var5, String var6, Object var7);
    }
}

