/****************************************************************************
 * apps/include/modbus/mbproto.h
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * SPDX-FileCopyrightText: 2006 Christian Walter <wolti@sil.at>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef __APPS_INCLUDE_MODBUS_MBPROTO_H
#define __APPS_INCLUDE_MODBUS_MBPROTO_H

#ifdef __cplusplus
extern "C"
{
#endif

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define MB_ADDRESS_BROADCAST                  (0)   /* Modbus broadcast address. */
#define MB_ADDRESS_MIN                        (1)   /* Smallest possible slave address. */
#define MB_ADDRESS_MAX                        (247) /* Biggest possible slave address. */
#define MB_FUNC_NONE                          (0)
#define MB_FUNC_READ_COILS                    (1)
#define MB_FUNC_READ_DISCRETE_INPUTS          (2)
#define MB_FUNC_WRITE_SINGLE_COIL             (5)
#define MB_FUNC_WRITE_MULTIPLE_COILS          (15)
#define MB_FUNC_READ_HOLDING_REGISTER         (3)
#define MB_FUNC_READ_INPUT_REGISTER           (4)
#define MB_FUNC_WRITE_REGISTER                (6)
#define MB_FUNC_WRITE_MULTIPLE_REGISTERS      (16)
#define MB_FUNC_READWRITE_MULTIPLE_REGISTERS  (23)
#define MB_FUNC_DIAG_READ_EXCEPTION           (7)
#define MB_FUNC_DIAG_DIAGNOSTIC               (8)
#define MB_FUNC_DIAG_GET_COM_EVENT_CNT        (11)
#define MB_FUNC_DIAG_GET_COM_EVENT_LOG        (12)
#define MB_FUNC_OTHER_REPORT_SLAVEID          (17)
#define MB_FUNC_ERROR                         (128)

/****************************************************************************
 * Public Type Definitions
 ****************************************************************************/

typedef enum
{
  MB_EX_NONE = 0x00,
  MB_EX_ILLEGAL_FUNCTION = 0x01,
  MB_EX_ILLEGAL_DATA_ADDRESS = 0x02,
  MB_EX_ILLEGAL_DATA_VALUE = 0x03,
  MB_EX_SLAVE_DEVICE_FAILURE = 0x04,
  MB_EX_ACKNOWLEDGE = 0x05,
  MB_EX_SLAVE_BUSY = 0x06,
  MB_EX_MEMORY_PARITY_ERROR = 0x08,
  MB_EX_GATEWAY_PATH_FAILED = 0x0a,
  MB_EX_GATEWAY_TGT_FAILED = 0x0b
} eMBException;

typedef eMBException(*pxMBFunctionHandler)(uint8_t *pucFrame, uint16_t *pusLength);

typedef struct
{
  uint8_t             ucFunctionCode;
  pxMBFunctionHandler pxHandler;
} xMBFunctionHandler;

#ifdef __cplusplus
}
#endif

#endif /* __APPS_INCLUDE_MODBUS_MBPROTO_H */
