/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.commandLine;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.toolkit.tls.TlsToolkitMain;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.commandLine.ExitCode;

public abstract class BaseCommandLine {
    public static final String HELP_ARG = "help";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String NIFI_TOOLKIT_HOME = "NIFI_TOOLKIT_HOME";
    public static final String FOOTER = System.lineSeparator() + "Java home: " + System.getenv("JAVA_HOME") + System.lineSeparator() + "NiFi Toolkit home: " + System.getenv("NIFI_TOOLKIT_HOME");
    private final Options options;
    private final String header;

    public BaseCommandLine(String header) {
        this.header = System.lineSeparator() + header + System.lineSeparator() + System.lineSeparator();
        this.options = new Options();
        this.options.addOption("h", HELP_ARG, false, "Print help and exit.");
    }

    protected void addOptionWithArg(String arg, String longArg, String description) {
        this.addOptionWithArg(arg, longArg, description, null);
    }

    protected void addOptionNoArg(String arg, String longArg, String description) {
        this.options.addOption(arg, longArg, false, description);
    }

    protected void addOptionWithArg(String arg, String longArg, String description, Object defaultVal) {
        String fullDescription = description;
        if (defaultVal != null) {
            fullDescription = fullDescription + " (default: " + defaultVal + ")";
        }
        this.options.addOption(arg, longArg, true, fullDescription);
    }

    public void printUsage(String errorMessage) {
        if (errorMessage != null) {
            System.out.println(errorMessage);
            System.out.println();
        }
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(160);
        helpFormatter.printHelp(TlsToolkitMain.class.getCanonicalName(), this.header, this.options, FOOTER, true);
    }

    protected <T> T printUsageAndThrow(String errorMessage, ExitCode exitCode) throws CommandLineParseException {
        this.printUsage(errorMessage);
        throw new CommandLineParseException(errorMessage, exitCode);
    }

    protected int getIntValue(CommandLine commandLine, String arg, int defaultVal) throws CommandLineParseException {
        try {
            return Integer.parseInt(commandLine.getOptionValue(arg, Integer.toString(defaultVal)));
        }
        catch (NumberFormatException e) {
            return (Integer)this.printUsageAndThrow("Expected integer for " + arg + " argument. (" + e.getMessage() + ")", ExitCode.ERROR_PARSING_INT_ARG);
        }
    }

    protected CommandLine doParse(String[] args) throws CommandLineParseException {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(this.options, args);
            if (commandLine.hasOption(HELP_ARG)) {
                return (CommandLine)this.printUsageAndThrow(null, ExitCode.HELP);
            }
            this.postParse(commandLine);
        }
        catch (ParseException e) {
            return (CommandLine)this.printUsageAndThrow("Error parsing command line. (" + e.getMessage() + ")", ExitCode.ERROR_PARSING_COMMAND_LINE);
        }
        return commandLine;
    }

    protected void postParse(CommandLine commandLine) throws CommandLineParseException {
    }

    public void parse(String ... args) throws CommandLineParseException {
        this.doParse(args);
    }
}

