/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class IntHashSet
extends AbstractIntHashSet
implements Sinkable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final IntList list;
    private IntIteratorImpl it;

    public IntHashSet() {
        this(16);
    }

    public IntHashSet(IntHashSet that) {
        this(that.capacity, that.loadFactor, -1);
        this.addAll(that);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0.4, -1);
    }

    public IntHashSet(int initialCapacity, double loadFactor, int noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.list = new IntList(this.free);
        this.clear();
    }

    public boolean add(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public final void addAll(IntHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    public void addAt(int index, int key) {
        this.keys[index] = key;
        this.list.add(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.list.clear();
    }

    public boolean contains(int key) {
        return this.keyIndex(key) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntHashSet that = (IntHashSet)o;
        if (this.size() != that.size()) {
            return false;
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            int key = this.list.getQuick(i);
            if (key == this.noEntryKeyValue || !that.excludes(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludes(int key) {
        return this.keyIndex(key) > -1;
    }

    public int get(int index) {
        return this.list.getQuick(index);
    }

    public int getLast() {
        return this.list.getLast();
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue) continue;
            hashCode += this.keys[i];
        }
        return hashCode;
    }

    public PrimitiveIterator.OfInt iterator() {
        if (this.it == null) {
            this.it = new IntIteratorImpl();
        } else {
            this.it.reset();
        }
        return this.it;
    }

    @Override
    public int remove(int key) {
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            int key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    @Override
    public void toSink(CharSink sink) {
        this.list.toSink(sink, this.noEntryKeyValue);
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        this.keys = new int[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        int n = this.list.size();
        this.free -= n;
        for (int i = 0; i < n; ++i) {
            int key;
            this.keys[this.keyIndex((int)key)] = key = this.list.getQuick(i);
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    private class IntIteratorImpl
    implements PrimitiveIterator.OfInt {
        private int keysIndex;
        private int yieldedCount;

        private IntIteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.yieldedCount < IntHashSet.this.size();
        }

        @Override
        public int nextInt() {
            while (this.keysIndex < IntHashSet.this.keys.length) {
                int entry = IntHashSet.this.keys[this.keysIndex];
                ++this.keysIndex;
                if (entry == IntHashSet.this.noEntryKeyValue) continue;
                ++this.yieldedCount;
                return entry;
            }
            throw new NoSuchElementException();
        }

        public void reset() {
            this.keysIndex = 0;
            this.yieldedCount = 0;
        }
    }
}

