/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueListRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByDeferredListValuesFilteredRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final LatestByValueListRecordCursor cursor;
    private final ObjList<Function> excludedSymbolFuncs;
    private final Function filter;
    private final int frameSymbolIndex;
    private final ObjList<Function> includedSymbolFuncs;

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @Nullable ObjList<Function> includedSymbolFuncs, @Nullable ObjList<Function> excludedSymbolFuncs, @Nullable Function filter, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        this.includedSymbolFuncs = includedSymbolFuncs != null ? new ObjList<Function>(includedSymbolFuncs) : null;
        this.excludedSymbolFuncs = excludedSymbolFuncs != null ? new ObjList<Function>(excludedSymbolFuncs) : null;
        this.filter = filter;
        this.frameSymbolIndex = columnIndexes.getQuick(columnIndex);
        this.cursor = new LatestByValueListRecordCursor(columnIndex, filter, columnIndexes, configuration.getDefaultSymbolCapacity(), includedSymbolFuncs != null);
    }

    public LatestByDeferredListValuesFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, int latestByIndex, Function filter, IntList columnIndexes) {
        this(configuration, metadata, dataFrameCursorFactory, latestByIndex, null, null, filter, columnIndexes);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByDeferredListValuesFiltered");
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.optAttr((CharSequence)"includedSymbols", this.includedSymbolFuncs);
        sink.optAttr((CharSequence)"excludedSymbols", this.excludedSymbolFuncs);
        sink.child(this.dataFrameCursorFactory);
    }

    private void lookupDeferredSymbols(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        int key;
        Function symbolFunc;
        int i;
        int n;
        StaticSymbolTable symbolMapReader;
        IntHashSet symbolKeys;
        if (this.includedSymbolFuncs != null) {
            symbolKeys = this.cursor.getIncludedSymbolKeys();
            symbolKeys.clear();
            symbolMapReader = dataFrameCursor.getSymbolTable(this.frameSymbolIndex);
            n = this.includedSymbolFuncs.size();
            for (i = 0; i < n; ++i) {
                symbolFunc = this.includedSymbolFuncs.getQuick(i);
                symbolFunc.init(dataFrameCursor, executionContext);
                key = symbolMapReader.keyOf(symbolFunc.getStr(null));
                if (key == -2) continue;
                symbolKeys.add(key);
            }
        }
        if (this.excludedSymbolFuncs != null) {
            symbolKeys = this.cursor.getExcludedSymbolKeys();
            symbolKeys.clear();
            symbolMapReader = dataFrameCursor.getSymbolTable(this.frameSymbolIndex);
            n = this.excludedSymbolFuncs.size();
            for (i = 0; i < n; ++i) {
                symbolFunc = this.excludedSymbolFuncs.getQuick(i);
                symbolFunc.init(dataFrameCursor, executionContext);
                key = symbolMapReader.keyOf(symbolFunc.getStr(null));
                if (key == -2) continue;
                symbolKeys.add(key);
            }
        }
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        this.cursor.destroy();
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.lookupDeferredSymbols(dataFrameCursor, executionContext);
        this.cursor.of(dataFrameCursor, executionContext);
        return this.cursor;
    }
}

