/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.hook.EventHookProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventService
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventService.class);
    static final int EVENT_QUEUE_SIZE = 10000;
    private final BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>(10000);
    private final ExecutorService scheduledExecutorService = Executors.newSingleThreadExecutor();
    private final List<EventHookProvider> eventHookProviders;

    @Autowired
    public EventService(List<EventHookProvider> eventHookProviders) {
        this.eventHookProviders = new ArrayList<EventHookProvider>(eventHookProviders);
    }

    @PostConstruct
    public void postConstruct() {
        LOGGER.info("Starting event consumer...");
        this.scheduledExecutorService.execute(() -> {
            while (!Thread.interrupted()) {
                try {
                    Event event = this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    for (EventHookProvider provider : this.eventHookProviders) {
                        try {
                            if (event.getEventType() != null && (event.getEventType() == null || !provider.shouldHandle(event.getEventType()))) continue;
                            provider.handle(event);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error handling event hook", (Throwable)e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while polling event queue");
                    return;
                }
            }
        });
        LOGGER.info("Event consumer started!");
    }

    public void destroy() throws Exception {
        LOGGER.info("Shutting down event consumer...");
        this.scheduledExecutorService.shutdownNow();
        LOGGER.info("Event consumer shutdown!");
    }

    public void publish(Event event) {
        if (event == null) {
            return;
        }
        try {
            event.validate();
            boolean queued = this.eventQueue.offer(event);
            if (!queued) {
                LOGGER.error("Unable to queue event because queue is full");
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Invalid event due to: " + e.getMessage(), (Throwable)e);
        }
    }
}

