/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReEncryptRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, ReEncryptRequest> {
    private static final SdkField<SdkBytes> CIPHERTEXT_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextBlob").getter(ReEncryptRequest.getter(ReEncryptRequest::ciphertextBlob)).setter(ReEncryptRequest.setter(Builder::ciphertextBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextBlob").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SourceEncryptionContext").getter(ReEncryptRequest.getter(ReEncryptRequest::sourceEncryptionContext)).setter(ReEncryptRequest.setter(Builder::sourceEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKeyId").getter(ReEncryptRequest.getter(ReEncryptRequest::sourceKeyId)).setter(ReEncryptRequest.setter(Builder::sourceKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceKeyId").build()}).build();
    private static final SdkField<String> DESTINATION_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationKeyId").getter(ReEncryptRequest.getter(ReEncryptRequest::destinationKeyId)).setter(ReEncryptRequest.setter(Builder::destinationKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationKeyId").build()}).build();
    private static final SdkField<Map<String, String>> DESTINATION_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DestinationEncryptionContext").getter(ReEncryptRequest.getter(ReEncryptRequest::destinationEncryptionContext)).setter(ReEncryptRequest.setter(Builder::destinationEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEncryptionAlgorithm").getter(ReEncryptRequest.getter(ReEncryptRequest::sourceEncryptionAlgorithmAsString)).setter(ReEncryptRequest.setter(Builder::sourceEncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEncryptionAlgorithm").build()}).build();
    private static final SdkField<String> DESTINATION_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationEncryptionAlgorithm").getter(ReEncryptRequest.getter(ReEncryptRequest::destinationEncryptionAlgorithmAsString)).setter(ReEncryptRequest.setter(Builder::destinationEncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEncryptionAlgorithm").build()}).build();
    private static final SdkField<List<String>> GRANT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GrantTokens").getter(ReEncryptRequest.getter(ReEncryptRequest::grantTokens)).setter(ReEncryptRequest.setter(Builder::grantTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ReEncryptRequest.getter(ReEncryptRequest::dryRun)).setter(ReEncryptRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIPHERTEXT_BLOB_FIELD, SOURCE_ENCRYPTION_CONTEXT_FIELD, SOURCE_KEY_ID_FIELD, DESTINATION_KEY_ID_FIELD, DESTINATION_ENCRYPTION_CONTEXT_FIELD, SOURCE_ENCRYPTION_ALGORITHM_FIELD, DESTINATION_ENCRYPTION_ALGORITHM_FIELD, GRANT_TOKENS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CiphertextBlob", CIPHERTEXT_BLOB_FIELD);
            this.put("SourceEncryptionContext", SOURCE_ENCRYPTION_CONTEXT_FIELD);
            this.put("SourceKeyId", SOURCE_KEY_ID_FIELD);
            this.put("DestinationKeyId", DESTINATION_KEY_ID_FIELD);
            this.put("DestinationEncryptionContext", DESTINATION_ENCRYPTION_CONTEXT_FIELD);
            this.put("SourceEncryptionAlgorithm", SOURCE_ENCRYPTION_ALGORITHM_FIELD);
            this.put("DestinationEncryptionAlgorithm", DESTINATION_ENCRYPTION_ALGORITHM_FIELD);
            this.put("GrantTokens", GRANT_TOKENS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final SdkBytes ciphertextBlob;
    private final Map<String, String> sourceEncryptionContext;
    private final String sourceKeyId;
    private final String destinationKeyId;
    private final Map<String, String> destinationEncryptionContext;
    private final String sourceEncryptionAlgorithm;
    private final String destinationEncryptionAlgorithm;
    private final List<String> grantTokens;
    private final Boolean dryRun;

    private ReEncryptRequest(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.sourceEncryptionContext = builder.sourceEncryptionContext;
        this.sourceKeyId = builder.sourceKeyId;
        this.destinationKeyId = builder.destinationKeyId;
        this.destinationEncryptionContext = builder.destinationEncryptionContext;
        this.sourceEncryptionAlgorithm = builder.sourceEncryptionAlgorithm;
        this.destinationEncryptionAlgorithm = builder.destinationEncryptionAlgorithm;
        this.grantTokens = builder.grantTokens;
        this.dryRun = builder.dryRun;
    }

    public final SdkBytes ciphertextBlob() {
        return this.ciphertextBlob;
    }

    public final boolean hasSourceEncryptionContext() {
        return this.sourceEncryptionContext != null && !(this.sourceEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceEncryptionContext() {
        return this.sourceEncryptionContext;
    }

    public final String sourceKeyId() {
        return this.sourceKeyId;
    }

    public final String destinationKeyId() {
        return this.destinationKeyId;
    }

    public final boolean hasDestinationEncryptionContext() {
        return this.destinationEncryptionContext != null && !(this.destinationEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> destinationEncryptionContext() {
        return this.destinationEncryptionContext;
    }

    public final EncryptionAlgorithmSpec sourceEncryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.sourceEncryptionAlgorithm);
    }

    public final String sourceEncryptionAlgorithmAsString() {
        return this.sourceEncryptionAlgorithm;
    }

    public final EncryptionAlgorithmSpec destinationEncryptionAlgorithm() {
        return EncryptionAlgorithmSpec.fromValue(this.destinationEncryptionAlgorithm);
    }

    public final String destinationEncryptionAlgorithmAsString() {
        return this.destinationEncryptionAlgorithm;
    }

    public final boolean hasGrantTokens() {
        return this.grantTokens != null && !(this.grantTokens instanceof SdkAutoConstructList);
    }

    public final List<String> grantTokens() {
        return this.grantTokens;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceEncryptionContext() ? this.sourceEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationEncryptionContext() ? this.destinationEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEncryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEncryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGrantTokens() ? this.grantTokens() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest other = (ReEncryptRequest)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && this.hasSourceEncryptionContext() == other.hasSourceEncryptionContext() && Objects.equals(this.sourceEncryptionContext(), other.sourceEncryptionContext()) && Objects.equals(this.sourceKeyId(), other.sourceKeyId()) && Objects.equals(this.destinationKeyId(), other.destinationKeyId()) && this.hasDestinationEncryptionContext() == other.hasDestinationEncryptionContext() && Objects.equals(this.destinationEncryptionContext(), other.destinationEncryptionContext()) && Objects.equals(this.sourceEncryptionAlgorithmAsString(), other.sourceEncryptionAlgorithmAsString()) && Objects.equals(this.destinationEncryptionAlgorithmAsString(), other.destinationEncryptionAlgorithmAsString()) && this.hasGrantTokens() == other.hasGrantTokens() && Objects.equals(this.grantTokens(), other.grantTokens()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ReEncryptRequest").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("SourceEncryptionContext", this.hasSourceEncryptionContext() ? this.sourceEncryptionContext() : null).add("SourceKeyId", (Object)this.sourceKeyId()).add("DestinationKeyId", (Object)this.destinationKeyId()).add("DestinationEncryptionContext", this.hasDestinationEncryptionContext() ? this.destinationEncryptionContext() : null).add("SourceEncryptionAlgorithm", (Object)this.sourceEncryptionAlgorithmAsString()).add("DestinationEncryptionAlgorithm", (Object)this.destinationEncryptionAlgorithmAsString()).add("GrantTokens", this.hasGrantTokens() ? this.grantTokens() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.ofNullable(clazz.cast(this.ciphertextBlob()));
            }
            case "SourceEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.sourceEncryptionContext()));
            }
            case "SourceKeyId": {
                return Optional.ofNullable(clazz.cast(this.sourceKeyId()));
            }
            case "DestinationKeyId": {
                return Optional.ofNullable(clazz.cast(this.destinationKeyId()));
            }
            case "DestinationEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.destinationEncryptionContext()));
            }
            case "SourceEncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.sourceEncryptionAlgorithmAsString()));
            }
            case "DestinationEncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.destinationEncryptionAlgorithmAsString()));
            }
            case "GrantTokens": {
                return Optional.ofNullable(clazz.cast(this.grantTokens()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptRequest, T> g) {
        return obj -> g.apply((ReEncryptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private SdkBytes ciphertextBlob;
        private Map<String, String> sourceEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String sourceKeyId;
        private String destinationKeyId;
        private Map<String, String> destinationEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String sourceEncryptionAlgorithm;
        private String destinationEncryptionAlgorithm;
        private List<String> grantTokens = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptRequest model) {
            super(model);
            this.ciphertextBlob(model.ciphertextBlob);
            this.sourceEncryptionContext(model.sourceEncryptionContext);
            this.sourceKeyId(model.sourceKeyId);
            this.destinationKeyId(model.destinationKeyId);
            this.destinationEncryptionContext(model.destinationEncryptionContext);
            this.sourceEncryptionAlgorithm(model.sourceEncryptionAlgorithm);
            this.destinationEncryptionAlgorithm(model.destinationEncryptionAlgorithm);
            this.grantTokens(model.grantTokens);
            this.dryRun(model.dryRun);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob == null ? null : this.ciphertextBlob.asByteBuffer();
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob(ciphertextBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextBlob));
        }

        @Override
        public final Builder ciphertextBlob(SdkBytes ciphertextBlob) {
            this.ciphertextBlob = ciphertextBlob;
            return this;
        }

        public final Map<String, String> getSourceEncryptionContext() {
            if (this.sourceEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceEncryptionContext;
        }

        public final void setSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
        }

        @Override
        public final Builder sourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
            this.sourceEncryptionContext = EncryptionContextTypeCopier.copy(sourceEncryptionContext);
            return this;
        }

        public final String getSourceKeyId() {
            return this.sourceKeyId;
        }

        public final void setSourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
        }

        @Override
        public final Builder sourceKeyId(String sourceKeyId) {
            this.sourceKeyId = sourceKeyId;
            return this;
        }

        public final String getDestinationKeyId() {
            return this.destinationKeyId;
        }

        public final void setDestinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
        }

        @Override
        public final Builder destinationKeyId(String destinationKeyId) {
            this.destinationKeyId = destinationKeyId;
            return this;
        }

        public final Map<String, String> getDestinationEncryptionContext() {
            if (this.destinationEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.destinationEncryptionContext;
        }

        public final void setDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
        }

        @Override
        public final Builder destinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
            this.destinationEncryptionContext = EncryptionContextTypeCopier.copy(destinationEncryptionContext);
            return this;
        }

        public final String getSourceEncryptionAlgorithm() {
            return this.sourceEncryptionAlgorithm;
        }

        public final void setSourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
        }

        @Override
        public final Builder sourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder sourceEncryptionAlgorithm(EncryptionAlgorithmSpec sourceEncryptionAlgorithm) {
            this.sourceEncryptionAlgorithm(sourceEncryptionAlgorithm == null ? null : sourceEncryptionAlgorithm.toString());
            return this;
        }

        public final String getDestinationEncryptionAlgorithm() {
            return this.destinationEncryptionAlgorithm;
        }

        public final void setDestinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
        }

        @Override
        public final Builder destinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder destinationEncryptionAlgorithm(EncryptionAlgorithmSpec destinationEncryptionAlgorithm) {
            this.destinationEncryptionAlgorithm(destinationEncryptionAlgorithm == null ? null : destinationEncryptionAlgorithm.toString());
            return this;
        }

        public final Collection<String> getGrantTokens() {
            if (this.grantTokens instanceof SdkAutoConstructList) {
                return null;
            }
            return this.grantTokens;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReEncryptRequest build() {
            return new ReEncryptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReEncryptRequest> {
        public Builder ciphertextBlob(SdkBytes var1);

        public Builder sourceEncryptionContext(Map<String, String> var1);

        public Builder sourceKeyId(String var1);

        public Builder destinationKeyId(String var1);

        public Builder destinationEncryptionContext(Map<String, String> var1);

        public Builder sourceEncryptionAlgorithm(String var1);

        public Builder sourceEncryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public Builder destinationEncryptionAlgorithm(String var1);

        public Builder destinationEncryptionAlgorithm(EncryptionAlgorithmSpec var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

