/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.expression.AttributeExpression;

public class EpochTimeEvaluator
extends NumberEvaluator {
    private final ChronoUnit chronoUnit;
    private final Evaluator<?> subjectEvaluator;

    public EpochTimeEvaluator(ChronoUnit chronoUnit, Evaluator<?> subjectEvaluator) {
        this.chronoUnit = chronoUnit;
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Number> evaluate(EvaluationContext evaluationContext) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(evaluationContext);
        if (result.getValue() == null) {
            return new NumberQueryResult(null);
        }
        if (result.getResultType() == AttributeExpression.ResultType.INSTANT) {
            Instant instant = ((InstantQueryResult)result).getValue();
            long time = this.chronoUnit.between(Instant.EPOCH, instant);
            return new NumberQueryResult(time);
        }
        return new NumberQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

