/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class DirectUnboundedByteSink
extends AbstractCharSink {
    private long _wptr;
    private long address;

    public DirectUnboundedByteSink() {
    }

    public DirectUnboundedByteSink(long address) {
        this.address = this._wptr = address;
    }

    public void clear(int len) {
        this._wptr = this.address + (long)len;
    }

    public long getAddress() {
        return this.address;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    public void of(long address) {
        this.address = this._wptr = address;
    }

    @Override
    public CharSink put(CharSequence cs) {
        int len = cs.length();
        Chars.asciiStrCpy(cs, len, this._wptr);
        this._wptr += (long)len;
        return this;
    }

    @Override
    public CharSink put(char c) {
        Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        Chars.asciiCopyTo(chars, start, len, this._wptr);
        this._wptr += (long)len;
        return this;
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalBuilder();
        long hi = this._wptr;
        for (long p = this.address; p < hi; ++p) {
            b.put((char)Unsafe.getUnsafe().getByte(p));
        }
        return ((Object)b).toString();
    }
}

