/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Rnd;

class RndStrFunction
extends StrFunction
implements Function {
    private final int lo;
    private final int nullRate;
    private final int range;
    private Rnd rnd;

    public RndStrFunction(int lo, int hi, int nullRate) {
        this.lo = lo;
        this.range = hi - lo + 1;
        this.nullRate = nullRate;
    }

    @Override
    public CharSequence getStr(Record rec) {
        if (this.rnd.nextInt() % this.nullRate == 1) {
            return null;
        }
        return this.rnd.nextChars(this.lo + this.rnd.nextPositiveInt() % this.range);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStr(rec);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.rnd = executionContext.getRandom();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("rnd_str(").val(this.lo).val(',').val(this.range + this.lo - 1).val(',').val(this.nullRate).val(')');
    }
}

