/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cutlass.line.tcp.AuthDb;
import io.questdb.cutlass.line.tcp.LineTcpAuthConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpConnectionContext;
import io.questdb.cutlass.line.tcp.LineTcpMeasurementScheduler;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.MutableIOContextFactory;
import io.questdb.std.Misc;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;

public class LineTcpReceiver
implements Closeable {
    private static final Log LOG = LogFactory.getLog(LineTcpReceiver.class);
    private final IODispatcher<LineTcpConnectionContext> dispatcher;
    private final Metrics metrics;
    private LineTcpMeasurementScheduler scheduler = null;

    public LineTcpReceiver(LineTcpReceiverConfiguration configuration, CairoEngine engine, WorkerPool ioWorkerPool, WorkerPool writerWorkerPool) {
        ObjectFactory<LineTcpConnectionContext> factory;
        this.metrics = engine.getMetrics();
        if (null == configuration.getAuthDbPath()) {
            LOG.info().$("using default context").$();
            factory = () -> new LineTcpConnectionContext(configuration, this.scheduler, this.metrics);
        } else {
            LOG.info().$("using authenticating context").$();
            AuthDb authDb = new AuthDb(configuration);
            factory = () -> new LineTcpAuthConnectionContext(configuration, authDb, this.scheduler, this.metrics);
        }
        MutableIOContextFactory<LineTcpConnectionContext> contextFactory = new MutableIOContextFactory<LineTcpConnectionContext>(factory, configuration.getConnectionPoolInitialCapacity());
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), contextFactory);
        ioWorkerPool.assign(this.dispatcher);
        this.scheduler = new LineTcpMeasurementScheduler(configuration, engine, ioWorkerPool, this.dispatcher, writerWorkerPool);
        int n = ioWorkerPool.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            ioWorkerPool.assignThreadLocalCleaner(i, contextFactory::freeThreadLocal);
        }
    }

    @Override
    public void close() {
        Misc.free(this.scheduler);
        Misc.free(this.dispatcher);
    }

    void setSchedulerListener(SchedulerListener listener) {
        this.scheduler.setListener(listener);
    }

    @FunctionalInterface
    public static interface SchedulerListener {
        public void onEvent(TableToken var1, int var2);
    }
}

