/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Event;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.PostConstructViewMapEvent;
import jakarta.faces.event.PreDestroyViewMapEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;

@ApplicationScoped
public class ViewScopeEventListenerBridge {
    @Inject
    @Initialized(value=ViewScoped.class)
    private Event<UIViewRoot> viewScopeInitializedEvent;
    @Inject
    @BeforeDestroyed(value=ViewScoped.class)
    private Event<UIViewRoot> viewScopeBeforeDestroyedEvent;
    @Inject
    @Destroyed(value=ViewScoped.class)
    private Event<UIViewRoot> viewScopeDestroyedEvent;

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostConstructViewMapEvent) {
            this.viewScopeInitializedEvent.fire((UIViewRoot)event.getSource());
        }
        if (event instanceof PreDestroyViewMapEvent) {
            this.viewScopeBeforeDestroyedEvent.fire((UIViewRoot)event.getSource());
            this.viewScopeDestroyedEvent.fire((UIViewRoot)event.getSource());
        }
    }
}

