/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectRealmCache;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.aether.graph.DependencyFilter;

@Named
@Singleton
public class DefaultProjectRealmCache
implements ProjectRealmCache,
Disposable {
    protected final Map<ProjectRealmCache.Key, ProjectRealmCache.CacheRecord> cache = new ConcurrentHashMap<ProjectRealmCache.Key, ProjectRealmCache.CacheRecord>();

    @Override
    public ProjectRealmCache.Key createKey(List<? extends ClassRealm> extensionRealms) {
        return new CacheKey(extensionRealms);
    }

    @Override
    public ProjectRealmCache.CacheRecord get(ProjectRealmCache.Key key) {
        return this.cache.get(key);
    }

    @Override
    public ProjectRealmCache.CacheRecord put(ProjectRealmCache.Key key, ClassRealm projectRealm, DependencyFilter extensionArtifactFilter) {
        Objects.requireNonNull(projectRealm, "projectRealm cannot be null");
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate project realm for extensions " + String.valueOf(key));
        }
        ProjectRealmCache.CacheRecord record = new ProjectRealmCache.CacheRecord(projectRealm, extensionArtifactFilter);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        for (ProjectRealmCache.CacheRecord record : this.cache.values()) {
            ClassRealm realm = record.getRealm();
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {}
        }
        this.cache.clear();
    }

    @Override
    public void register(MavenProject project, ProjectRealmCache.Key key, ProjectRealmCache.CacheRecord record) {
    }

    public void dispose() {
        this.flush();
    }

    protected static class CacheKey
    implements ProjectRealmCache.Key {
        private final List<? extends ClassRealm> extensionRealms;
        private final int hashCode;

        public CacheKey(List<? extends ClassRealm> extensionRealms) {
            this.extensionRealms = extensionRealms != null ? Collections.unmodifiableList(extensionRealms) : Collections.emptyList();
            this.hashCode = this.extensionRealms.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CacheKey) {
                CacheKey other = (CacheKey)o;
                return this.extensionRealms.equals(other.extensionRealms);
            }
            return false;
        }

        public String toString() {
            return this.extensionRealms.toString();
        }
    }
}

