/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.StringDigestUtil;

public class HashingNameMapper
implements NameMapper {
    public static final String CONFIG_PROP_DEPTH = "aether.syncContext.named.hashing.depth";
    public static final int DEFAULT_DEPTH = 2;
    private final NameMapper delegate;

    public HashingNameMapper(NameMapper delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return true;
    }

    @Override
    public Collection<NamedLockKey> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        int depth = ConfigUtils.getInteger((RepositorySystemSession)session, (int)2, (String[])new String[]{CONFIG_PROP_DEPTH});
        if (depth < 0 || depth > 4) {
            throw new IllegalArgumentException("allowed depth value is between 0 and 4 (inclusive)");
        }
        return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(k -> NamedLockKey.of((String)this.hashName(k.name(), depth), (Collection)k.resources())).collect(Collectors.toList());
    }

    private String hashName(String name, int depth) {
        String hashedName = StringDigestUtil.sha1((String)name);
        if (depth == 0) {
            return hashedName;
        }
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < hashedName.length() && i / 2 < depth; i += 2) {
            prefix.append(hashedName, i, i + 2).append("/");
        }
        return prefix.append(hashedName).toString();
    }
}

