/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="prefixes")
public final class PrefixesRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport {
    public static final String NAME = "prefixes";
    private static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.prefixes.";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.prefixes";
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.prefixes.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    static final String PREFIXES_FILE_PREFIX = "prefixes-";
    static final String PREFIXES_FILE_SUFFIX = ".txt";
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefixesRemoteRepositoryFilterSource.class);
    private final RepositoryLayoutProvider repositoryLayoutProvider;
    private final ConcurrentHashMap<RemoteRepository, Node> prefixes;
    private final ConcurrentHashMap<RemoteRepository, RepositoryLayout> layouts;
    private static final Node NOT_PRESENT_NODE = new Node("not-present-node");
    private static final RemoteRepositoryFilter.Result NOT_PRESENT_RESULT = new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Prefix file not present");

    @Inject
    public PrefixesRemoteRepositoryFilterSource(RepositoryLayoutProvider repositoryLayoutProvider) {
        this.repositoryLayoutProvider = Objects.requireNonNull(repositoryLayoutProvider);
        this.prefixes = new ConcurrentHashMap();
        this.layouts = new ConcurrentHashMap();
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session)) {
            return new PrefixesFilter(session, this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false));
        }
        return null;
    }

    private RepositoryLayout cacheLayout(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.layouts.computeIfAbsent(remoteRepository, r -> {
            try {
                return this.repositoryLayoutProvider.newRepositoryLayout(session, remoteRepository);
            }
            catch (NoRepositoryLayoutException e) {
                return null;
            }
        });
    }

    private Node cacheNode(Path basedir, RemoteRepository remoteRepository) {
        return this.prefixes.computeIfAbsent(remoteRepository, r -> this.loadRepositoryPrefixes(basedir, remoteRepository));
    }

    private Node loadRepositoryPrefixes(Path baseDir, RemoteRepository remoteRepository) {
        Path filePath;
        block13: {
            filePath = baseDir.resolve(PREFIXES_FILE_PREFIX + remoteRepository.getId() + PREFIXES_FILE_SUFFIX);
            if (Files.isReadable(filePath)) {
                Node node;
                block12: {
                    BufferedReader reader2 = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
                    try {
                        String prefix;
                        LOGGER.debug("Loading prefixes for remote repository {} from file '{}'", (Object)remoteRepository.getId(), (Object)filePath);
                        Node root = new Node("");
                        int lines = 0;
                        while ((prefix = reader2.readLine()) != null) {
                            if (prefix.startsWith("#") || prefix.trim().isEmpty()) continue;
                            ++lines;
                            Node currentNode = root;
                            for (String element : PrefixesRemoteRepositoryFilterSource.elementsOf(prefix)) {
                                currentNode = currentNode.addSibling(element);
                            }
                        }
                        LOGGER.info("Loaded {} prefixes for remote repository {}", (Object)lines, (Object)remoteRepository.getId());
                        node = root;
                        if (reader2 == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader2 != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FileNotFoundException reader2) {
                            break block13;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    reader2.close();
                }
                return node;
            }
        }
        LOGGER.debug("Prefix file for remote repository {} not found at '{}'", (Object)remoteRepository, (Object)filePath);
        return NOT_PRESENT_NODE;
    }

    private static List<String> elementsOf(String path) {
        return Arrays.stream(path.split("/")).filter(e -> e != null && !e.isEmpty()).collect(Collectors.toList());
    }

    private static class Node {
        private final String name;
        private final HashMap<String, Node> siblings;

        private Node(String name) {
            this.name = name;
            this.siblings = new HashMap();
        }

        public String getName() {
            return this.name;
        }

        public boolean isLeaf() {
            return this.siblings.isEmpty();
        }

        public Node addSibling(String name) {
            Node sibling = this.siblings.get(name);
            if (sibling == null) {
                sibling = new Node(name);
                this.siblings.put(name, sibling);
            }
            return sibling;
        }

        public Node getSibling(String name) {
            return this.siblings.get(name);
        }
    }

    private class PrefixesFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;
        private final Path basedir;

        private PrefixesFilter(RepositorySystemSession session, Path basedir) {
            this.session = session;
            this.basedir = basedir;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == null) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(artifact, false).getPath());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == null) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(metadata, false).getPath());
        }

        private RemoteRepositoryFilter.Result acceptPrefix(RemoteRepository remoteRepository, String path) {
            Node root = PrefixesRemoteRepositoryFilterSource.this.cacheNode(this.basedir, remoteRepository);
            if (NOT_PRESENT_NODE == root) {
                return NOT_PRESENT_RESULT;
            }
            ArrayList<String> prefix = new ArrayList<String>();
            List pathElements = PrefixesRemoteRepositoryFilterSource.elementsOf(path);
            Node currentNode = root;
            for (String pathElement : pathElements) {
                prefix.add(pathElement);
                if ((currentNode = currentNode.getSibling(pathElement)) != null && !currentNode.isLeaf()) continue;
                break;
            }
            if (currentNode != null && currentNode.isLeaf()) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Prefix " + String.join((CharSequence)"/", prefix) + " allowed from " + remoteRepository);
            }
            return new RemoteRepositoryFilterSourceSupport.SimpleResult(false, "Prefix " + String.join((CharSequence)"/", prefix) + " NOT allowed from " + remoteRepository);
        }
    }
}

