/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.json;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.json.JsonFilterReader;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;

public class JsonUrlRewriteFilterReader
extends JsonFilterReader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Resolver resolver;
    private UrlRewriter rewriter;
    private UrlRewriter.Direction direction;

    public JsonUrlRewriteFilterReader(Reader reader, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException {
        super(reader, config);
        this.resolver = resolver;
        this.rewriter = rewriter;
        this.direction = direction;
    }

    @Override
    protected String filterValueString(String name, String value, String rule) {
        if (rule != null || UrlRewriter.Direction.OUT == this.direction) {
            try {
                Template input = Parser.parseLiteral((String)value);
                Template output = this.rewriter.rewrite(this.resolver, input, this.direction, rule);
                if (output != null) {
                    value = output.getPattern();
                }
            }
            catch (URISyntaxException e) {
                LOG.failedToParseValueForUrlRewrite(value);
            }
            return value;
        }
        LOG.skippingRewritingJsonRequestBody();
        return value;
    }
}

