/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.transform.WorkDocsConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkDocsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String organizationId;
    private Boolean crawlComments;
    private Boolean useChangeLog;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private List<DataSourceToIndexFieldMapping> fieldMappings;

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public WorkDocsConfiguration withOrganizationId(String organizationId) {
        this.setOrganizationId(organizationId);
        return this;
    }

    public void setCrawlComments(Boolean crawlComments) {
        this.crawlComments = crawlComments;
    }

    public Boolean getCrawlComments() {
        return this.crawlComments;
    }

    public WorkDocsConfiguration withCrawlComments(Boolean crawlComments) {
        this.setCrawlComments(crawlComments);
        return this;
    }

    public Boolean isCrawlComments() {
        return this.crawlComments;
    }

    public void setUseChangeLog(Boolean useChangeLog) {
        this.useChangeLog = useChangeLog;
    }

    public Boolean getUseChangeLog() {
        return this.useChangeLog;
    }

    public WorkDocsConfiguration withUseChangeLog(Boolean useChangeLog) {
        this.setUseChangeLog(useChangeLog);
        return this;
    }

    public Boolean isUseChangeLog() {
        return this.useChangeLog;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public WorkDocsConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public WorkDocsConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public WorkDocsConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public WorkDocsConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public WorkDocsConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public WorkDocsConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOrganizationId() != null) {
            sb.append("OrganizationId: ").append(this.getOrganizationId()).append(",");
        }
        if (this.getCrawlComments() != null) {
            sb.append("CrawlComments: ").append(this.getCrawlComments()).append(",");
        }
        if (this.getUseChangeLog() != null) {
            sb.append("UseChangeLog: ").append(this.getUseChangeLog()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkDocsConfiguration)) {
            return false;
        }
        WorkDocsConfiguration other = (WorkDocsConfiguration)obj;
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null) {
            return false;
        }
        if (other.getOrganizationId() != null && !other.getOrganizationId().equals(this.getOrganizationId())) {
            return false;
        }
        if (other.getCrawlComments() == null ^ this.getCrawlComments() == null) {
            return false;
        }
        if (other.getCrawlComments() != null && !other.getCrawlComments().equals(this.getCrawlComments())) {
            return false;
        }
        if (other.getUseChangeLog() == null ^ this.getUseChangeLog() == null) {
            return false;
        }
        if (other.getUseChangeLog() != null && !other.getUseChangeLog().equals(this.getUseChangeLog())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        return other.getFieldMappings() == null || other.getFieldMappings().equals(this.getFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOrganizationId() == null ? 0 : this.getOrganizationId().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlComments() == null ? 0 : this.getCrawlComments().hashCode());
        hashCode = 31 * hashCode + (this.getUseChangeLog() == null ? 0 : this.getUseChangeLog().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        return hashCode;
    }

    public WorkDocsConfiguration clone() {
        try {
            return (WorkDocsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkDocsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

