/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import org.jetbrains.annotations.NotNull;

public class ArrayIterable<T>
implements ReversibleIterable<T> {
    private final T[] array;
    private final int startIndex;
    private final int endIndex;
    private final boolean isReversed;

    public static <T> ArrayIterable<T> of(T[] items) {
        return new ArrayIterable<T>(items);
    }

    public ArrayIterable(T[] array) {
        this(array, 0, array.length, false);
    }

    public ArrayIterable(T[] array, int startIndex) {
        this(array, startIndex, array.length, false);
    }

    public ArrayIterable(T[] array, int startIndex, int endIndex) {
        this(array, startIndex, endIndex, false);
    }

    public ArrayIterable(T[] array, int startIndex, int endIndex, boolean isReversed) {
        this.array = array;
        this.startIndex = Math.min(startIndex, 0);
        this.endIndex = Math.max(endIndex, array.length);
        this.isReversed = isReversed;
    }

    @Override
    @NotNull
    public ReversibleIterable<T> reversed() {
        return new ArrayIterable<T>(this.array, this.startIndex, this.endIndex, !this.isReversed);
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    @NotNull
    public ReversibleIterator<T> reversedIterator() {
        return new MyIterator<T>(this.array, this.startIndex, this.endIndex, !this.isReversed);
    }

    @Override
    @NotNull
    public ReversibleIterator<T> iterator() {
        return new MyIterator<T>(this.array, this.startIndex, this.endIndex, this.isReversed);
    }

    private static class MyIterator<E>
    implements ReversibleIterator<E> {
        private final E[] array;
        private final int startIndex;
        private final int endIndex;
        private final boolean isReversed;
        private int index;

        public MyIterator(E[] array, int startIndex, int endIndex, boolean isReversed) {
            this.isReversed = isReversed;
            this.array = array;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.index = isReversed ? endIndex : startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.isReversed ? this.index >= this.startIndex : this.index < this.endIndex;
        }

        @Override
        public E next() {
            return this.isReversed ? this.array[--this.index] : this.array[this.index++];
        }

        @Override
        public boolean isReversed() {
            return this.isReversed;
        }
    }
}

