/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.FilesetVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.ibatis.annotations.Param;

public class FilesetVersionPostgreSQLProvider
extends FilesetVersionBaseSQLProvider {
    @Override
    public String softDeleteFilesetVersionsByMetalakeId(Long metalakeId) {
        return "UPDATE fileset_version_info SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteFilesetVersionsByCatalogId(Long catalogId) {
        return "UPDATE fileset_version_info SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteFilesetVersionsBySchemaId(Long schemaId) {
        return "UPDATE fileset_version_info SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteFilesetVersionsByFilesetId(Long filesetId) {
        return "UPDATE fileset_version_info SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE fileset_id = #{filesetId} AND deleted_at = 0";
    }

    @Override
    public String deleteFilesetVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM fileset_version_info WHERE id IN (SELECT id FROM fileset_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }

    @Override
    public String softDeleteFilesetVersionsByRetentionLine(Long filesetId, long versionRetentionLine, int limit) {
        return "UPDATE fileset_version_info SET deleted_at = floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000))) WHERE fileset_id = #{filesetId} AND version <= #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit}";
    }

    @Override
    public String insertFilesetVersionOnDuplicateKeyUpdate(FilesetVersionPO filesetVersionPO) {
        return "INSERT INTO fileset_version_info(metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location, deleted_at) VALUES( #{filesetVersion.metalakeId}, #{filesetVersion.catalogId}, #{filesetVersion.schemaId}, #{filesetVersion.filesetId}, #{filesetVersion.version}, #{filesetVersion.filesetComment}, #{filesetVersion.properties}, #{filesetVersion.storageLocation}, #{filesetVersion.deletedAt} ) ON CONFLICT(fileset_id, version, deleted_at) DO UPDATE SET metalake_id = #{filesetVersion.metalakeId}, catalog_id = #{filesetVersion.catalogId}, schema_id = #{filesetVersion.schemaId}, fileset_id = #{filesetVersion.filesetId}, version = #{filesetVersion.version}, fileset_comment = #{filesetVersion.filesetComment}, properties = #{filesetVersion.properties}, storage_location = #{filesetVersion.storageLocation}, deleted_at = #{filesetVersion.deletedAt}";
    }
}

