/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.jolbox.bonecp.BoneCPConfigMBean;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneCPConfig
implements BoneCPConfigMBean,
Cloneable,
Serializable {
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final long serialVersionUID = 6090570773474131622L;
    private static final String CONFIG_TOSTRING = "JDBC URL = %s, Username = %s, partitions = %d, max (per partition) = %d, min (per partition) = %d, idle max age = %d min, idle test period = %d min, strategy = %s";
    private static final String CONFIG_DS_TOSTRING = "JDBC URL = (via datasource bean), Username = (via datasource bean), partitions = %d, max (per partition) = %d, min (per partition) = %d, idle max age = %d min, idle test period = %d min, strategy = %s";
    private static final Logger logger = LoggerFactory.getLogger(BoneCPConfig.class);
    private int minConnectionsPerPartition = 1;
    private int maxConnectionsPerPartition = 2;
    private int acquireIncrement = 2;
    private int partitionCount = 1;
    private String jdbcUrl;
    private String username;
    private String password;
    private long idleConnectionTestPeriodInSeconds = 14400L;
    private long idleMaxAgeInSeconds = 3600L;
    private String connectionTestStatement;
    private int statementsCacheSize = 0;
    private int statementsCachedPerConnection = 0;
    private int releaseHelperThreads = 0;
    private int statementReleaseHelperThreads = 0;
    private ConnectionHook connectionHook;
    private String initSQL;
    private boolean closeConnectionWatch;
    private boolean logStatementsEnabled;
    private long acquireRetryDelayInMs = 7000L;
    private int acquireRetryAttempts = 5;
    private boolean lazyInit;
    private boolean transactionRecoveryEnabled;
    private String connectionHookClassName;
    private ClassLoader classLoader = this.getClassLoader();
    private String poolName;
    private boolean disableJMX;
    private DataSource datasourceBean;
    private long queryExecuteTimeLimitInMs = 0L;
    private int poolAvailabilityThreshold = 0;
    private boolean disableConnectionTracking;
    @VisibleForTesting
    protected Properties driverProperties;
    private long connectionTimeoutInMs = 0L;
    private long closeConnectionWatchTimeoutInMs = 0L;
    private long maxConnectionAgeInSeconds = 0L;
    private String configFile;
    private String serviceOrder = "FIFO";
    private boolean statisticsEnabled;
    private boolean defaultAutoCommit = true;
    private boolean defaultReadOnly;
    private String defaultTransactionIsolation;
    private String defaultCatalog;
    private int defaultTransactionIsolationValue = -1;
    private boolean externalAuth;
    private boolean deregisterDriverOnClose;
    private boolean nullOnConnectionTimeout;
    private boolean resetConnectionOnClose;
    private boolean detectUnresolvedTransactions;
    private String poolStrategy = "DEFAULT";
    private boolean closeOpenStatements;
    private boolean detectUnclosedStatements;
    private Properties clientInfo;

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = (String)Preconditions.checkNotNull((Object)poolName);
    }

    @Override
    public int getMinConnectionsPerPartition() {
        return this.minConnectionsPerPartition;
    }

    public void setMinConnectionsPerPartition(int minConnectionsPerPartition) {
        this.minConnectionsPerPartition = minConnectionsPerPartition;
    }

    @Override
    public int getMaxConnectionsPerPartition() {
        return this.maxConnectionsPerPartition;
    }

    public void setMaxConnectionsPerPartition(int maxConnectionsPerPartition) {
        this.maxConnectionsPerPartition = maxConnectionsPerPartition;
    }

    @Override
    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUser(String username) {
        this.setUsername(username);
    }

    public String getUser() {
        return this.getUsername();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public long getIdleConnectionTestPeriod() {
        logger.warn("Please use getIdleConnectionTestPeriodInMinutes in place of getIdleConnectionTestPeriod. This method has been deprecated.");
        return this.getIdleConnectionTestPeriodInMinutes();
    }

    @Deprecated
    public void setIdleConnectionTestPeriod(long idleConnectionTestPeriod) {
        logger.warn("Please use setIdleConnectionTestPeriodInMinutes in place of setIdleConnectionTestPeriod. This method has been deprecated.");
        this.setIdleConnectionTestPeriod(idleConnectionTestPeriod * 60L, TimeUnit.SECONDS);
    }

    @Override
    public long getIdleConnectionTestPeriodInMinutes() {
        return this.idleConnectionTestPeriodInSeconds / 60L;
    }

    public long getIdleConnectionTestPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.idleConnectionTestPeriodInSeconds, TimeUnit.SECONDS);
    }

    public void setIdleConnectionTestPeriodInMinutes(long idleConnectionTestPeriod) {
        this.setIdleConnectionTestPeriod(idleConnectionTestPeriod * 60L, TimeUnit.SECONDS);
    }

    public void setIdleConnectionTestPeriodInSeconds(long idleConnectionTestPeriod) {
        this.setIdleConnectionTestPeriod(idleConnectionTestPeriod, TimeUnit.SECONDS);
    }

    public void setIdleConnectionTestPeriod(long idleConnectionTestPeriod, TimeUnit timeUnit) {
        this.idleConnectionTestPeriodInSeconds = TimeUnit.SECONDS.convert(idleConnectionTestPeriod, (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit))));
    }

    @Deprecated
    public long getIdleMaxAge() {
        logger.warn("Please use getIdleMaxAgeInMinutes in place of getIdleMaxAge. This method has been deprecated.");
        return this.getIdleMaxAgeInMinutes();
    }

    public long getIdleMaxAge(TimeUnit timeUnit) {
        return timeUnit.convert(this.idleMaxAgeInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public long getIdleMaxAgeInMinutes() {
        return this.idleMaxAgeInSeconds / 60L;
    }

    @Deprecated
    public void setIdleMaxAge(long idleMaxAge) {
        logger.warn("Please use setIdleMaxAgeInMinutes in place of setIdleMaxAge. This method has been deprecated.");
        this.setIdleMaxAgeInMinutes(idleMaxAge);
    }

    public void setIdleMaxAgeInMinutes(long idleMaxAge) {
        this.setIdleMaxAge(idleMaxAge * 60L, TimeUnit.SECONDS);
    }

    public void setIdleMaxAgeInSeconds(long idleMaxAge) {
        this.setIdleMaxAge(idleMaxAge, TimeUnit.SECONDS);
    }

    public void setIdleMaxAge(long idleMaxAge, TimeUnit timeUnit) {
        this.idleMaxAgeInSeconds = TimeUnit.SECONDS.convert(idleMaxAge, (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit))));
    }

    @Override
    public String getConnectionTestStatement() {
        return this.connectionTestStatement;
    }

    public void setConnectionTestStatement(String connectionTestStatement) {
        this.connectionTestStatement = (String)Preconditions.checkNotNull((Object)connectionTestStatement);
    }

    @Deprecated
    public int getPreparedStatementsCacheSize() {
        logger.warn("Please use getStatementsCacheSize in place of getPreparedStatementsCacheSize. This method has been deprecated.");
        return this.statementsCacheSize;
    }

    @Deprecated
    public int getPreparedStatementCacheSize() {
        logger.warn("Please use getStatementsCacheSize in place of getPreparedStatementCacheSize. This method has been deprecated.");
        return this.statementsCacheSize;
    }

    @Deprecated
    public void setPreparedStatementsCacheSize(int preparedStatementsCacheSize) {
        logger.warn("Please use setStatementsCacheSize in place of setPreparedStatementsCacheSize. This method has been deprecated.");
        this.statementsCacheSize = preparedStatementsCacheSize;
    }

    public void setStatementsCacheSize(int statementsCacheSize) {
        this.statementsCacheSize = statementsCacheSize;
    }

    @Override
    public int getStatementsCacheSize() {
        return this.statementsCacheSize;
    }

    @Deprecated
    public void setStatementCacheSize(int statementsCacheSize) {
        logger.warn("Please use setStatementsCacheSize in place of setStatementCacheSize. This method has been deprecated.");
        this.statementsCacheSize = statementsCacheSize;
    }

    @Deprecated
    public int getStatementCacheSize() {
        logger.warn("Please use getStatementsCacheSize in place of getStatementCacheSize. This method has been deprecated.");
        return this.statementsCacheSize;
    }

    @Override
    @Deprecated
    public int getReleaseHelperThreads() {
        return this.releaseHelperThreads;
    }

    @Deprecated
    public void setReleaseHelperThreads(int releaseHelperThreads) {
        logger.warn("releaseHelperThreads has been deprecated -- it tends to slow down your application more.");
        this.releaseHelperThreads = releaseHelperThreads;
    }

    @Override
    @Deprecated
    public int getStatementsCachedPerConnection() {
        return this.statementsCachedPerConnection;
    }

    @Deprecated
    public void setStatementsCachedPerConnection(int statementsCachedPerConnection) {
        this.statementsCachedPerConnection = statementsCachedPerConnection;
    }

    @Override
    public ConnectionHook getConnectionHook() {
        return this.connectionHook;
    }

    public void setConnectionHook(ConnectionHook connectionHook) {
        this.connectionHook = connectionHook;
    }

    @Override
    public String getInitSQL() {
        return this.initSQL;
    }

    public void setInitSQL(String initSQL) {
        this.initSQL = (String)Preconditions.checkNotNull((Object)initSQL);
    }

    public boolean isCloseConnectionWatch() {
        return this.closeConnectionWatch;
    }

    public void setCloseConnectionWatch(boolean closeConnectionWatch) {
        this.closeConnectionWatch = closeConnectionWatch;
    }

    @Override
    public boolean isLogStatementsEnabled() {
        return this.logStatementsEnabled;
    }

    public void setLogStatementsEnabled(boolean logStatementsEnabled) {
        this.logStatementsEnabled = logStatementsEnabled;
    }

    @Deprecated
    public long getAcquireRetryDelay() {
        logger.warn("Please use getAcquireRetryDelayInMs in place of getAcquireRetryDelay. This method has been deprecated.");
        return this.acquireRetryDelayInMs;
    }

    @Deprecated
    public void setAcquireRetryDelay(int acquireRetryDelayInMs) {
        logger.warn("Please use setAcquireRetryDelayInMs in place of setAcquireRetryDelay. This method has been deprecated.");
        this.acquireRetryDelayInMs = acquireRetryDelayInMs;
    }

    @Override
    public long getAcquireRetryDelayInMs() {
        return this.acquireRetryDelayInMs;
    }

    public long getAcquireRetryDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.acquireRetryDelayInMs, TimeUnit.MILLISECONDS);
    }

    public void setAcquireRetryDelayInMs(long acquireRetryDelay) {
        this.setAcquireRetryDelay(acquireRetryDelay, TimeUnit.MILLISECONDS);
    }

    public void setAcquireRetryDelay(long acquireRetryDelay, TimeUnit timeUnit) {
        this.acquireRetryDelayInMs = TimeUnit.MILLISECONDS.convert(acquireRetryDelay, timeUnit);
    }

    @Override
    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    @Override
    public boolean isTransactionRecoveryEnabled() {
        return this.transactionRecoveryEnabled;
    }

    public void setTransactionRecoveryEnabled(boolean transactionRecoveryEnabled) {
        this.transactionRecoveryEnabled = transactionRecoveryEnabled;
    }

    @Override
    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.acquireRetryAttempts = acquireRetryAttempts;
    }

    public void setConnectionHookClassName(String connectionHookClassName) {
        this.connectionHookClassName = (String)Preconditions.checkNotNull((Object)connectionHookClassName);
        try {
            Object hookClass = this.loadClass(connectionHookClassName).newInstance();
            this.connectionHook = (ConnectionHook)hookClass;
        }
        catch (Exception e) {
            logger.error("Unable to create an instance of the connection hook class (" + connectionHookClassName + ")");
            this.connectionHook = null;
        }
    }

    @Override
    public String getConnectionHookClassName() {
        return this.connectionHookClassName;
    }

    @Override
    public boolean isDisableJMX() {
        return this.disableJMX;
    }

    public void setDisableJMX(boolean disableJMX) {
        this.disableJMX = disableJMX;
    }

    public DataSource getDatasourceBean() {
        return this.datasourceBean;
    }

    public void setDatasourceBean(DataSource datasourceBean) {
        this.datasourceBean = datasourceBean;
    }

    @Deprecated
    public long getQueryExecuteTimeLimit() {
        logger.warn("Please use getQueryExecuteTimeLimitInMs in place of getQueryExecuteTimeLimit. This method has been deprecated.");
        return this.queryExecuteTimeLimitInMs;
    }

    @Deprecated
    public void setQueryExecuteTimeLimit(int queryExecuteTimeLimit) {
        logger.warn("Please use setQueryExecuteTimeLimitInMs in place of setQueryExecuteTimeLimit. This method has been deprecated.");
        this.setQueryExecuteTimeLimit(queryExecuteTimeLimit, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getQueryExecuteTimeLimitInMs() {
        return this.queryExecuteTimeLimitInMs;
    }

    public long getQueryExecuteTimeLimit(TimeUnit timeUnit) {
        return timeUnit.convert(this.queryExecuteTimeLimitInMs, TimeUnit.MILLISECONDS);
    }

    public void setQueryExecuteTimeLimitInMs(long queryExecuteTimeLimit) {
        this.setQueryExecuteTimeLimit(queryExecuteTimeLimit, TimeUnit.MILLISECONDS);
    }

    public void setQueryExecuteTimeLimit(long queryExecuteTimeLimit, TimeUnit timeUnit) {
        this.queryExecuteTimeLimitInMs = TimeUnit.MILLISECONDS.convert(queryExecuteTimeLimit, timeUnit);
    }

    @Override
    public int getPoolAvailabilityThreshold() {
        return this.poolAvailabilityThreshold;
    }

    public void setPoolAvailabilityThreshold(int poolAvailabilityThreshold) {
        this.poolAvailabilityThreshold = poolAvailabilityThreshold;
    }

    @Override
    public boolean isDisableConnectionTracking() {
        return this.disableConnectionTracking;
    }

    public void setDisableConnectionTracking(boolean disableConnectionTracking) {
        this.disableConnectionTracking = disableConnectionTracking;
    }

    @Deprecated
    public long getConnectionTimeout() {
        logger.warn("Please use getConnectionTimeoutInMs in place of getConnectionTimeout. This method has been deprecated.");
        return this.connectionTimeoutInMs;
    }

    @Deprecated
    public void setConnectionTimeout(long connectionTimeout) {
        logger.warn("Please use setConnectionTimeoutInMs in place of setConnectionTimeout. This method has been deprecated.");
        this.connectionTimeoutInMs = connectionTimeout;
    }

    @Override
    public long getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public long getConnectionTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.connectionTimeoutInMs, TimeUnit.MILLISECONDS);
    }

    public void setConnectionTimeoutInMs(long connectionTimeoutinMs) {
        this.setConnectionTimeout(connectionTimeoutinMs, TimeUnit.MILLISECONDS);
    }

    public void setConnectionTimeout(long connectionTimeout, TimeUnit timeUnit) {
        this.connectionTimeoutInMs = TimeUnit.MILLISECONDS.convert(connectionTimeout, timeUnit);
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void setDriverProperties(Properties driverProperties) {
        this.driverProperties = new Properties();
        this.driverProperties.putAll((Map<?, ?>)((Map)Preconditions.checkNotNull((Object)driverProperties)));
    }

    @Deprecated
    public long getCloseConnectionWatchTimeout() {
        logger.warn("Please use getCloseConnectionWatchTimeoutInMs in place of getCloseConnectionWatchTimeout. This method has been deprecated.");
        return this.closeConnectionWatchTimeoutInMs;
    }

    @Deprecated
    public void setCloseConnectionWatchTimeout(long closeConnectionWatchTimeout) {
        logger.warn("Please use setCloseConnectionWatchTimeoutInMs in place of setCloseConnectionWatchTimeout. This method has been deprecated.");
        this.setCloseConnectionWatchTimeoutInMs(closeConnectionWatchTimeout);
    }

    @Override
    public long getCloseConnectionWatchTimeoutInMs() {
        return this.closeConnectionWatchTimeoutInMs;
    }

    public long getCloseConnectionWatchTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.closeConnectionWatchTimeoutInMs, TimeUnit.MILLISECONDS);
    }

    public void setCloseConnectionWatchTimeoutInMs(long closeConnectionWatchTimeout) {
        this.setCloseConnectionWatchTimeout(closeConnectionWatchTimeout, TimeUnit.MILLISECONDS);
    }

    public void setCloseConnectionWatchTimeout(long closeConnectionWatchTimeout, TimeUnit timeUnit) {
        this.closeConnectionWatchTimeoutInMs = TimeUnit.MILLISECONDS.convert(closeConnectionWatchTimeout, timeUnit);
    }

    @Override
    @Deprecated
    public int getStatementReleaseHelperThreads() {
        return this.statementReleaseHelperThreads;
    }

    @Deprecated
    public void setStatementReleaseHelperThreads(int statementReleaseHelperThreads) {
        logger.warn("statementReleaseHelperThreads has been deprecated -- it tends to slow down your application more.");
        this.statementReleaseHelperThreads = statementReleaseHelperThreads;
    }

    @Deprecated
    public long getMaxConnectionAge() {
        logger.warn("Please use getMaxConnectionAgeInSeconds in place of getMaxConnectionAge. This method has been deprecated.");
        return this.maxConnectionAgeInSeconds;
    }

    @Override
    public long getMaxConnectionAgeInSeconds() {
        return this.maxConnectionAgeInSeconds;
    }

    public long getMaxConnectionAge(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxConnectionAgeInSeconds, TimeUnit.SECONDS);
    }

    @Deprecated
    public void setMaxConnectionAge(long maxConnectionAgeInSeconds) {
        logger.warn("Please use setmaxConnectionAgeInSecondsInSeconds in place of setMaxConnectionAge. This method has been deprecated.");
        this.maxConnectionAgeInSeconds = maxConnectionAgeInSeconds;
    }

    public void setMaxConnectionAgeInSeconds(long maxConnectionAgeInSeconds) {
        this.setMaxConnectionAge(maxConnectionAgeInSeconds, TimeUnit.SECONDS);
    }

    public void setMaxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        this.maxConnectionAgeInSeconds = TimeUnit.SECONDS.convert(maxConnectionAge, timeUnit);
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = (String)Preconditions.checkNotNull((Object)configFile);
    }

    @Override
    public String getServiceOrder() {
        return this.serviceOrder;
    }

    public void setServiceOrder(String serviceOrder) {
        this.serviceOrder = (String)Preconditions.checkNotNull((Object)serviceOrder);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = (Boolean)Preconditions.checkNotNull((Object)defaultReadOnly);
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = (String)Preconditions.checkNotNull((Object)defaultCatalog);
    }

    public String getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        this.defaultTransactionIsolation = (String)Preconditions.checkNotNull((Object)defaultTransactionIsolation);
    }

    protected int getDefaultTransactionIsolationValue() {
        return this.defaultTransactionIsolationValue;
    }

    protected void setDefaultTransactionIsolationValue(int defaultTransactionIsolationValue) {
        this.defaultTransactionIsolationValue = defaultTransactionIsolationValue;
    }

    public BoneCPConfig() {
        this.loadProperties("bonecp-default-config.xml");
        this.loadProperties("bonecp-config.xml");
    }

    public BoneCPConfig(Properties props) throws Exception {
        this();
        this.setProperties((Properties)Preconditions.checkNotNull((Object)props));
    }

    public BoneCPConfig(String sectionName) throws Exception {
        this(BoneCPConfig.class.getResourceAsStream("/bonecp-config.xml"), (String)Preconditions.checkNotNull((Object)sectionName));
    }

    public BoneCPConfig(InputStream xmlConfigFile, String sectionName) throws Exception {
        this();
        this.setXMLProperties(xmlConfigFile, (String)Preconditions.checkNotNull((Object)sectionName));
    }

    private void setXMLProperties(InputStream xmlConfigFile, String sectionName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlConfigFile);
            doc.getDocumentElement().normalize();
            Properties settings = this.parseXML(doc, null);
            if (sectionName != null) {
                settings.putAll((Map<?, ?>)this.parseXML(doc, sectionName));
            }
            this.setProperties(settings);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (xmlConfigFile != null) {
                xmlConfigFile.close();
            }
        }
    }

    private String lowerFirst(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public void setProperties(Properties props) throws Exception {
        for (Method method : BoneCPConfig.class.getDeclaredMethods()) {
            String val;
            String tmp = null;
            if (method.getName().startsWith("is")) {
                tmp = this.lowerFirst(method.getName().substring(2));
            } else {
                if (!method.getName().startsWith("set")) continue;
                tmp = this.lowerFirst(method.getName().substring(3));
            }
            if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Integer.TYPE)) {
                val = props.getProperty(tmp);
                if (val == null) {
                    val = props.getProperty("bonecp." + tmp);
                }
                if (val != null) {
                    try {
                        method.invoke((Object)this, Integer.parseInt(val));
                    }
                    catch (NumberFormatException e) {}
                }
            } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Long.TYPE)) {
                val = props.getProperty(tmp);
                if (val == null) {
                    val = props.getProperty("bonecp." + tmp);
                }
                if (val != null) {
                    try {
                        method.invoke((Object)this, Long.parseLong(val));
                    }
                    catch (NumberFormatException e) {}
                }
            } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)) {
                val = props.getProperty(tmp);
                if (val == null) {
                    val = props.getProperty("bonecp." + tmp);
                }
                if (val != null) {
                    method.invoke((Object)this, val);
                }
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(Boolean.TYPE)) continue;
            val = props.getProperty(tmp);
            if (val == null) {
                val = props.getProperty("bonecp." + tmp);
            }
            if (val == null) continue;
            method.invoke((Object)this, Boolean.parseBoolean(val));
        }
    }

    private Properties parseXML(Document doc, String sectionName) {
        Node node;
        int found = -1;
        Properties results = new Properties();
        NodeList config = null;
        if (sectionName == null) {
            config = doc.getElementsByTagName("default-config");
            found = 0;
        } else {
            config = doc.getElementsByTagName("named-config");
            if (config != null && config.getLength() > 0) {
                for (int i = 0; i < config.getLength(); ++i) {
                    Node name;
                    NamedNodeMap attributes;
                    Node node2 = config.item(i);
                    if (node2.getNodeType() != 1 || (attributes = node2.getAttributes()) == null || attributes.getLength() <= 0 || !(name = attributes.getNamedItem("name")).getNodeValue().equalsIgnoreCase(sectionName)) continue;
                    found = i;
                    break;
                }
            }
            if (found == -1) {
                config = null;
                logger.warn("Did not find " + sectionName + " section in config file. Reverting to defaults.");
            }
        }
        if (config != null && config.getLength() > 0 && (node = config.item(found)).getNodeType() == 1) {
            Element elementEntry = (Element)node;
            NodeList childNodeList = elementEntry.getChildNodes();
            for (int j = 0; j < childNodeList.getLength(); ++j) {
                Element piece;
                NamedNodeMap attributes;
                Node node_j = childNodeList.item(j);
                if (node_j.getNodeType() != 1 || (attributes = (piece = (Element)node_j).getAttributes()) == null || attributes.getLength() <= 0) continue;
                results.put(attributes.item(0).getNodeValue(), piece.getTextContent());
            }
        }
        return results;
    }

    public boolean isExternalAuth() {
        return this.externalAuth;
    }

    public void setExternalAuth(boolean externalAuth) {
        this.externalAuth = externalAuth;
    }

    public void sanitize() {
        if (this.configFile != null) {
            this.loadProperties(this.configFile);
        }
        if (this.poolStrategy == null || !this.poolStrategy.equalsIgnoreCase("DEFAULT") && !this.poolStrategy.equalsIgnoreCase("CACHED")) {
            logger.warn("Unrecognised pool strategy. Allowed values are DEFAULT and CACHED. Setting to DEFAULT.");
            this.poolStrategy = "DEFAULT";
        }
        this.poolStrategy = this.poolStrategy.toUpperCase();
        if (this.poolAvailabilityThreshold < 0 || this.poolAvailabilityThreshold > 100) {
            this.poolAvailabilityThreshold = 20;
        }
        if (this.defaultTransactionIsolation != null) {
            this.defaultTransactionIsolation = this.defaultTransactionIsolation.trim().toUpperCase();
            if (this.defaultTransactionIsolation.equals("NONE")) {
                this.defaultTransactionIsolationValue = 0;
            } else if (this.defaultTransactionIsolation.equals("READ_COMMITTED") || this.defaultTransactionIsolation.equals("READ COMMITTED")) {
                this.defaultTransactionIsolationValue = 2;
            } else if (this.defaultTransactionIsolation.equals("REPEATABLE_READ") || this.defaultTransactionIsolation.equals("REPEATABLE READ")) {
                this.defaultTransactionIsolationValue = 4;
            } else if (this.defaultTransactionIsolation.equals("READ_UNCOMMITTED") || this.defaultTransactionIsolation.equals("READ UNCOMMITTED")) {
                this.defaultTransactionIsolationValue = 1;
            } else if (this.defaultTransactionIsolation.equals("SERIALIZABLE")) {
                this.defaultTransactionIsolationValue = 8;
            } else {
                logger.warn("Unrecognized defaultTransactionIsolation value. Using driver default.");
                this.defaultTransactionIsolationValue = -1;
            }
        }
        if (this.maxConnectionsPerPartition < 1) {
            logger.warn("Max Connections < 1. Setting to 20");
            this.maxConnectionsPerPartition = 20;
        }
        if (this.minConnectionsPerPartition < 0) {
            logger.warn("Min Connections < 0. Setting to 1");
            this.minConnectionsPerPartition = 1;
        }
        if (this.minConnectionsPerPartition > this.maxConnectionsPerPartition) {
            logger.warn("Min Connections > max connections");
            this.minConnectionsPerPartition = this.maxConnectionsPerPartition;
        }
        if (this.acquireIncrement <= 0) {
            logger.warn("acquireIncrement <= 0. Setting to 1.");
            this.acquireIncrement = 1;
        }
        if (this.partitionCount < 1) {
            logger.warn("partitions < 1! Setting to 1");
            this.partitionCount = 1;
        }
        if (this.releaseHelperThreads < 0) {
            logger.warn("releaseHelperThreads < 0! Setting to 0");
            this.releaseHelperThreads = 0;
        }
        if (this.statementReleaseHelperThreads < 0) {
            logger.warn("statementReleaseHelperThreads < 0! Setting to 0");
            this.statementReleaseHelperThreads = 0;
        }
        if (this.statementsCacheSize < 0) {
            logger.warn("preparedStatementsCacheSize < 0! Setting to 0");
            this.statementsCacheSize = 0;
        }
        if (this.acquireRetryDelayInMs <= 0L) {
            this.acquireRetryDelayInMs = 1000L;
        }
        if (!this.externalAuth && this.datasourceBean == null && this.driverProperties == null && (this.jdbcUrl == null || this.jdbcUrl.trim().equals(""))) {
            logger.warn("JDBC url was not set in config!");
        }
        if (!this.externalAuth && this.datasourceBean == null && this.driverProperties == null && (this.username == null || this.username.trim().equals(""))) {
            logger.warn("JDBC username was not set in config!");
        }
        if (!this.externalAuth && this.datasourceBean == null && this.driverProperties == null && this.password == null) {
            logger.warn("JDBC password was not set in config!");
        }
        if (!this.externalAuth && this.datasourceBean == null && this.driverProperties != null) {
            if (this.driverProperties.get(USER) == null && this.username == null) {
                logger.warn("JDBC username not set in driver properties and not set in pool config either");
            } else if (this.driverProperties.get(USER) == null && this.username != null) {
                logger.warn("JDBC username not set in driver properties, copying it from pool config");
                this.driverProperties.setProperty(USER, this.username);
            } else if (this.username != null && !this.driverProperties.get(USER).equals(this.username)) {
                logger.warn("JDBC username set in driver properties does not match the one set in the pool config.  Overriding it with pool config.");
                this.driverProperties.setProperty(USER, this.username);
            }
        }
        if (!this.externalAuth && this.datasourceBean == null && this.driverProperties != null) {
            if (this.driverProperties.get(PASSWORD) == null && this.password == null) {
                logger.warn("JDBC password not set in driver properties and not set in pool config either");
            } else if (this.driverProperties.get(PASSWORD) == null && this.password != null) {
                logger.warn("JDBC password not set in driver properties, copying it from pool config");
                this.driverProperties.setProperty(PASSWORD, this.password);
            } else if (this.password != null && !this.driverProperties.get(PASSWORD).equals(this.password)) {
                logger.warn("JDBC password set in driver properties does not match the one set in the pool config. Overriding it with pool config.");
                this.driverProperties.setProperty(PASSWORD, this.password);
            }
            this.username = this.driverProperties.getProperty(USER);
            this.password = this.driverProperties.getProperty(PASSWORD);
        }
        if (this.username != null) {
            this.username = this.username.trim();
        }
        if (this.jdbcUrl != null) {
            this.jdbcUrl = this.jdbcUrl.trim();
        }
        if (this.password != null) {
            this.password = this.password.trim();
        }
        if (this.connectionTestStatement != null) {
            this.connectionTestStatement = this.connectionTestStatement.trim();
        }
        this.serviceOrder = this.serviceOrder.toUpperCase();
        if (!this.serviceOrder.equals("FIFO") && !this.serviceOrder.equals("LIFO")) {
            logger.warn("Queue service order is not set to FIFO or LIFO. Defaulting to FIFO.");
            this.serviceOrder = "FIFO";
        }
        if (this.logStatementsEnabled && !logger.isDebugEnabled()) {
            logger.warn("LogStatementsEnabled is set to true, but log4j level is not set at DEBUG. Disabling statement logging.");
            this.logStatementsEnabled = false;
        }
    }

    protected void loadProperties(String filename) {
        URL url;
        ClassLoader thclassLoader = Thread.currentThread().getContextClassLoader();
        if (thclassLoader != null && (url = thclassLoader.getResource(filename)) != null) {
            try {
                this.setXMLProperties(url.openStream(), null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String toString() {
        String result = null;
        result = this.datasourceBean != null ? String.format(CONFIG_DS_TOSTRING, this.partitionCount, this.maxConnectionsPerPartition, this.minConnectionsPerPartition, this.getIdleMaxAgeInMinutes(), this.getIdleConnectionTestPeriodInMinutes(), this.poolStrategy) : String.format(CONFIG_TOSTRING, this.jdbcUrl, this.username, this.partitionCount, this.maxConnectionsPerPartition, this.minConnectionsPerPartition, this.getIdleMaxAgeInMinutes(), this.getIdleConnectionTestPeriodInMinutes(), this.poolStrategy);
        return result;
    }

    protected Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(clazz);
        }
        return Class.forName(clazz, true, this.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public BoneCPConfig clone() throws CloneNotSupportedException {
        Field[] fields;
        BoneCPConfig clone = (BoneCPConfig)super.clone();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                field.set(clone, field.get(this));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return clone;
    }

    public boolean hasSameConfiguration(BoneCPConfig that) {
        return that != null && Objects.equal((Object)this.acquireIncrement, (Object)that.getAcquireIncrement()) && Objects.equal((Object)this.acquireRetryDelayInMs, (Object)that.getAcquireRetryDelayInMs()) && Objects.equal((Object)this.closeConnectionWatch, (Object)that.isCloseConnectionWatch()) && Objects.equal((Object)this.logStatementsEnabled, (Object)that.isLogStatementsEnabled()) && Objects.equal((Object)this.connectionHook, (Object)that.getConnectionHook()) && Objects.equal((Object)this.connectionTestStatement, (Object)that.getConnectionTestStatement()) && Objects.equal((Object)this.idleConnectionTestPeriodInSeconds, (Object)that.getIdleConnectionTestPeriod(TimeUnit.SECONDS)) && Objects.equal((Object)this.idleMaxAgeInSeconds, (Object)that.getIdleMaxAge(TimeUnit.SECONDS)) && Objects.equal((Object)this.initSQL, (Object)that.getInitSQL()) && Objects.equal((Object)this.jdbcUrl, (Object)that.getJdbcUrl()) && Objects.equal((Object)this.maxConnectionsPerPartition, (Object)that.getMaxConnectionsPerPartition()) && Objects.equal((Object)this.minConnectionsPerPartition, (Object)that.getMinConnectionsPerPartition()) && Objects.equal((Object)this.partitionCount, (Object)that.getPartitionCount()) && Objects.equal((Object)this.releaseHelperThreads, (Object)that.getReleaseHelperThreads()) && Objects.equal((Object)this.statementsCacheSize, (Object)that.getStatementsCacheSize()) && Objects.equal((Object)this.username, (Object)that.getUsername()) && Objects.equal((Object)this.password, (Object)that.getPassword()) && Objects.equal((Object)this.lazyInit, (Object)that.isLazyInit()) && Objects.equal((Object)this.transactionRecoveryEnabled, (Object)that.isTransactionRecoveryEnabled()) && Objects.equal((Object)this.acquireRetryAttempts, (Object)that.getAcquireRetryAttempts()) && Objects.equal((Object)this.statementReleaseHelperThreads, (Object)that.getStatementReleaseHelperThreads()) && Objects.equal((Object)this.closeConnectionWatchTimeoutInMs, (Object)that.getCloseConnectionWatchTimeout()) && Objects.equal((Object)this.connectionTimeoutInMs, (Object)that.getConnectionTimeoutInMs()) && Objects.equal((Object)this.datasourceBean, (Object)that.getDatasourceBean()) && Objects.equal((Object)this.getQueryExecuteTimeLimitInMs(), (Object)that.getQueryExecuteTimeLimitInMs()) && Objects.equal((Object)this.poolAvailabilityThreshold, (Object)that.getPoolAvailabilityThreshold()) && Objects.equal((Object)this.poolName, (Object)that.getPoolName()) && Objects.equal((Object)this.disableConnectionTracking, (Object)that.isDisableConnectionTracking());
    }

    public boolean isDeregisterDriverOnClose() {
        return this.deregisterDriverOnClose;
    }

    public void setDeregisterDriverOnClose(boolean deregisterDriverOnClose) {
        this.deregisterDriverOnClose = deregisterDriverOnClose;
    }

    public boolean isNullOnConnectionTimeout() {
        return this.nullOnConnectionTimeout;
    }

    public void setNullOnConnectionTimeout(boolean nullOnConnectionTimeout) {
        this.nullOnConnectionTimeout = nullOnConnectionTimeout;
    }

    public boolean isResetConnectionOnClose() {
        return this.resetConnectionOnClose;
    }

    public void setResetConnectionOnClose(boolean resetConnectionOnClose) {
        this.resetConnectionOnClose = resetConnectionOnClose;
    }

    public boolean isDetectUnresolvedTransactions() {
        return this.detectUnresolvedTransactions;
    }

    public void setDetectUnresolvedTransactions(boolean detectUnresolvedTransactions) {
        this.detectUnresolvedTransactions = detectUnresolvedTransactions;
    }

    public String getPoolStrategy() {
        return this.poolStrategy;
    }

    public void setPoolStrategy(String poolStrategy) {
        this.poolStrategy = poolStrategy;
    }

    public boolean isCloseOpenStatements() {
        return this.closeOpenStatements;
    }

    public void setCloseOpenStatements(boolean closeOpenStatements) {
        this.closeOpenStatements = closeOpenStatements;
    }

    public boolean isDetectUnclosedStatements() {
        return this.detectUnclosedStatements;
    }

    public void setDetectUnclosedStatements(boolean detectUnclosedStatements) {
        this.detectUnclosedStatements = detectUnclosedStatements;
    }

    public void setClientInfo(Properties properties) {
        this.clientInfo = properties;
    }

    public Properties getClientInfo() {
        return this.clientInfo;
    }
}

