/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PartitionSet;
import org.apache.iceberg.util.StructLikeMap;

public class PartitionMap<V>
extends AbstractMap<Pair<Integer, StructLike>, V> {
    private final Map<Integer, PartitionSpec> specs;
    private final Map<Integer, Map<StructLike, V>> partitionMaps;

    private PartitionMap(Map<Integer, PartitionSpec> specs) {
        this.specs = specs;
        this.partitionMaps = Maps.newHashMap();
    }

    public static <T> PartitionMap<T> create(Map<Integer, PartitionSpec> specs) {
        return new PartitionMap(specs);
    }

    @Override
    public int size() {
        return this.partitionMaps.values().stream().mapToInt(Map::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.partitionMaps.values().stream().allMatch(Map::isEmpty);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.execute(key, this::containsKey, false);
    }

    public boolean containsKey(int specId, StructLike struct) {
        Map<StructLike, V> partitionMap = this.partitionMaps.get(specId);
        return partitionMap != null && partitionMap.containsKey(struct);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.partitionMaps.values().stream().anyMatch(map -> map.containsValue(value));
    }

    @Override
    public V get(Object key) {
        return this.execute(key, this::get, null);
    }

    public V get(int specId, StructLike struct) {
        Map<StructLike, V> partitionMap = this.partitionMaps.get(specId);
        return partitionMap != null ? (V)partitionMap.get(struct) : null;
    }

    @Override
    public V put(Pair<Integer, StructLike> key, V value) {
        return this.put(key.first(), key.second(), value);
    }

    public V put(int specId, StructLike struct, V value) {
        Map partitionMap = this.partitionMaps.computeIfAbsent(specId, this::newPartitionMap);
        return partitionMap.put(struct, value);
    }

    @Override
    public void putAll(Map<? extends Pair<Integer, StructLike>, ? extends V> otherMap) {
        otherMap.forEach(this::put);
    }

    @Override
    public V remove(Object key) {
        return this.execute(key, this::removeKey, null);
    }

    public V removeKey(int specId, StructLike struct) {
        Map<StructLike, V> partitionMap = this.partitionMaps.get(specId);
        return partitionMap != null ? (V)partitionMap.remove(struct) : null;
    }

    @Override
    public void clear() {
        this.partitionMaps.clear();
    }

    @Override
    public Set<Pair<Integer, StructLike>> keySet() {
        PartitionSet keySet = PartitionSet.create(this.specs);
        for (Map.Entry<Integer, Map<StructLike, V>> specIdAndPartitionMap : this.partitionMaps.entrySet()) {
            int specId = specIdAndPartitionMap.getKey();
            Map<StructLike, V> partitionMap = specIdAndPartitionMap.getValue();
            for (StructLike partition : partitionMap.keySet()) {
                keySet.add(specId, partition);
            }
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = Lists.newArrayList();
        for (Map<StructLike, V> partitionMap : this.partitionMaps.values()) {
            values.addAll(partitionMap.values());
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public Set<Map.Entry<Pair<Integer, StructLike>, V>> entrySet() {
        HashSet entrySet = Sets.newHashSet();
        for (Map.Entry<Integer, Map<StructLike, V>> specIdAndPartitionMap : this.partitionMaps.entrySet()) {
            int specId = specIdAndPartitionMap.getKey();
            Map<StructLike, V> partitionMap = specIdAndPartitionMap.getValue();
            for (Map.Entry<StructLike, V> structAndValue : partitionMap.entrySet()) {
                entrySet.add(new PartitionEntry(specId, structAndValue));
            }
        }
        return Collections.unmodifiableSet(entrySet);
    }

    public V computeIfAbsent(int specId, StructLike struct, Supplier<V> valueSupplier) {
        Map partitionMap = this.partitionMaps.computeIfAbsent(specId, this::newPartitionMap);
        return (V)partitionMap.computeIfAbsent(struct, key -> valueSupplier.get());
    }

    private Map<StructLike, V> newPartitionMap(int specId) {
        PartitionSpec spec = this.specs.get(specId);
        Preconditions.checkNotNull((Object)spec, (String)"Cannot find spec with ID %s: %s", (int)specId, this.specs);
        return StructLikeMap.create(spec.partitionType());
    }

    @Override
    public String toString() {
        return this.partitionMaps.entrySet().stream().flatMap(this::toStrings).collect(Collectors.joining(", ", "{", "}"));
    }

    private Stream<String> toStrings(Map.Entry<Integer, Map<StructLike, V>> entry) {
        PartitionSpec spec = this.specs.get(entry.getKey());
        return entry.getValue().entrySet().stream().map(innerEntry -> this.toString(spec, (Map.Entry<StructLike, V>)innerEntry));
    }

    private String toString(PartitionSpec spec, Map.Entry<StructLike, V> entry) {
        StructLike struct = entry.getKey();
        V value = entry.getValue();
        return spec.partitionToPath(struct) + " -> " + (value == this ? "(this Map)" : value);
    }

    private <R> R execute(Object key, BiFunction<Integer, StructLike, R> action, R defaultValue) {
        if (key instanceof Pair) {
            Object first = ((Pair)key).first();
            Object second = ((Pair)key).second();
            if (first instanceof Integer && (second == null || second instanceof StructLike)) {
                return action.apply((Integer)first, (StructLike)second);
            }
        } else if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not support null keys");
        }
        return defaultValue;
    }

    private static class PartitionEntry<V>
    implements Map.Entry<Pair<Integer, StructLike>, V> {
        private final int specId;
        private final Map.Entry<StructLike, V> structAndValue;

        private PartitionEntry(int specId, Map.Entry<StructLike, V> structAndValue) {
            this.specId = specId;
            this.structAndValue = structAndValue;
        }

        @Override
        public Pair<Integer, StructLike> getKey() {
            return Pair.of(this.specId, this.structAndValue.getKey());
        }

        @Override
        public V getValue() {
            return this.structAndValue.getValue();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.specId, this.structAndValue);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            PartitionEntry that = (PartitionEntry)other;
            return this.specId == that.specId && Objects.equals(this.structAndValue, that.structAndValue);
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException("Cannot set value");
        }
    }
}

