/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.iceberg.service.metrics.IcebergMetricsManager;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces/{namespace}/tables")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableOperations.class);
    @VisibleForTesting
    public static final String X_ICEBERG_ACCESS_DELEGATION = "X-Iceberg-Access-Delegation";
    private IcebergMetricsManager icebergMetricsManager;
    private ObjectMapper icebergObjectMapper;
    private IcebergTableOperationDispatcher tableOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergTableOperations(IcebergMetricsManager icebergMetricsManager, IcebergTableOperationDispatcher tableOperationDispatcher) {
        this.icebergMetricsManager = icebergMetricsManager;
        this.tableOperationDispatcher = tableOperationDispatcher;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-table", absolute=true)
    public Response listTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("List Iceberg tables, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        ListTablesResponse listTablesResponse = this.tableOperationDispatcher.listTable(context, icebergNS);
        return IcebergRestUtils.ok(listTablesResponse);
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-table", absolute=true)
    public Response createTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, CreateTableRequest createTableRequest, @HeaderParam(value="X-Iceberg-Access-Delegation") String accessDelegation) {
        boolean isCredentialVending = this.isCredentialVending(accessDelegation);
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Create Iceberg table, catalog: {}, namespace: {}, create table request: {}, accessDelegation: {}, isCredentialVending: {}", new Object[]{catalogName, icebergNS, createTableRequest, accessDelegation, isCredentialVending});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName, isCredentialVending);
        LoadTableResponse loadTableResponse = this.tableOperationDispatcher.createTable(context, icebergNS, createTableRequest);
        return IcebergRestUtils.ok(loadTableResponse);
    }

    @POST
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="update-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-table", absolute=true)
    public Response updateTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, UpdateTableRequest updateTableRequest) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        if (LOG.isInfoEnabled()) {
            LOG.info("Update Iceberg table, catalog: {}, namespace: {}, table: {}, updateTableRequest: {}", new Object[]{catalogName, icebergNS, table, this.SerializeUpdateTableRequest(updateTableRequest)});
        }
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
        LoadTableResponse loadTableResponse = this.tableOperationDispatcher.updateTable(context, tableIdentifier, updateTableRequest);
        return IcebergRestUtils.ok(loadTableResponse);
    }

    @DELETE
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="drop-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-table", absolute=true)
    public Response dropTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @DefaultValue(value="false") @QueryParam(value="purgeRequested") boolean purgeRequested) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Drop Iceberg table, catalog: {}, namespace: {}, table: {}, purgeRequested: {}", new Object[]{catalogName, icebergNS, table, purgeRequested});
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{namespace, table});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        this.tableOperationDispatcher.dropTable(context, tableIdentifier, purgeRequested);
        return IcebergRestUtils.noContent();
    }

    @GET
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="load-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-table", absolute=true)
    public Response loadTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @DefaultValue(value="all") @QueryParam(value="snapshots") String snapshots, @HeaderParam(value="X-Iceberg-Access-Delegation") String accessDelegation) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        boolean isCredentialVending = this.isCredentialVending(accessDelegation);
        LOG.info("Load Iceberg table, catalog: {}, namespace: {}, table: {}, access delegation: {}, credential vending: {}", new Object[]{catalogName, icebergNS, table, accessDelegation, isCredentialVending});
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName, isCredentialVending);
        LoadTableResponse loadTableResponse = this.tableOperationDispatcher.loadTable(context, tableIdentifier);
        return IcebergRestUtils.ok(loadTableResponse);
    }

    @HEAD
    @Path(value="{table}")
    @Produces(value={"application/json"})
    @Timed(name="table-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="table-exits", absolute=true)
    public Response tableExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table) {
        String catalogName = IcebergRestUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Check Iceberg table exists, catalog: {}, namespace: {}, table: {}", new Object[]{catalogName, icebergNS, table});
        IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)icebergNS, (String)table);
        boolean exists = this.tableOperationDispatcher.tableExists(context, tableIdentifier);
        if (exists) {
            return IcebergRestUtils.noContent();
        }
        return IcebergRestUtils.notExists();
    }

    @POST
    @Path(value="{table}/metrics")
    @Produces(value={"application/json"})
    @Timed(name="report-table-metrics.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="report-table-metrics", absolute=true)
    public Response reportTableMetrics(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, ReportMetricsRequest request) {
        this.icebergMetricsManager.recordMetric(request.report());
        return IcebergRestUtils.noContent();
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }

    private String SerializeUpdateTableRequest(UpdateTableRequest updateTableRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)updateTableRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update table request failed", (Throwable)e);
            return updateTableRequest.toString();
        }
    }

    private boolean isCredentialVending(String accessDelegation) {
        if (StringUtils.isBlank((CharSequence)accessDelegation)) {
            return false;
        }
        if ("vended-credentials".equalsIgnoreCase(accessDelegation)) {
            return true;
        }
        if ("remote-signing".equalsIgnoreCase(accessDelegation)) {
            throw new UnsupportedOperationException("Gravitino IcebergRESTServer doesn't support remote signing");
        }
        throw new IllegalArgumentException("X-Iceberg-Access-Delegation: " + accessDelegation + " is illegal, Iceberg REST spec supports: [vended-credentials,remote-signing], Gravitino Iceberg REST server supports: vended-credentials");
    }
}

