/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare.bounds;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MultiBounds
extends SearchBounds {
    @GridToStringInclude
    private final List<SearchBounds> bounds;

    public MultiBounds(RexNode condition, List<SearchBounds> bounds) {
        super(condition);
        this.bounds = bounds;
    }

    public List<SearchBounds> bounds() {
        return this.bounds;
    }

    @Override
    public SearchBounds transform(Function<RexNode, RexNode> tranformFunction) {
        return new MultiBounds(tranformFunction.apply(this.condition()), Commons.transform(this.bounds, b -> b.transform(tranformFunction)));
    }

    @Override
    public SearchBounds.Type type() {
        return SearchBounds.Type.MULTI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bounds.equals(((MultiBounds)o).bounds);
    }

    public int hashCode() {
        return Objects.hash(this.bounds);
    }

    public String toString() {
        return S.toString(MultiBounds.class, (Object)this);
    }
}

