/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Objects;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import org.apache.calcite.avatica.remote.CommonsHttpClientPoolCache;
import org.apache.calcite.avatica.remote.DoAsAvaticaHttpClient;
import org.apache.calcite.avatica.remote.GSSAuthenticateable;
import org.apache.calcite.avatica.remote.HostnameVerificationConfigurable;
import org.apache.calcite.avatica.remote.HttpClientPoolConfigurable;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.apache.calcite.avatica.remote.KeyStoreConfigurable;
import org.apache.calcite.avatica.remote.TrustStoreConfigurable;
import org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaHttpClientFactoryImpl
implements AvaticaHttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaHttpClientFactoryImpl.class);
    public static final String HTTP_CLIENT_IMPL_DEFAULT = AvaticaCommonsHttpClientImpl.class.getName();
    public static final AvaticaHttpClientFactoryImpl INSTANCE = new AvaticaHttpClientFactoryImpl();

    public static AvaticaHttpClientFactoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public AvaticaHttpClient getClient(URL url, ConnectionConfig config, KerberosConnection kerberosUtil) {
        AuthenticationType authType;
        AvaticaHttpClient client;
        String className = config.httpClientClass();
        if (null == className) {
            className = HTTP_CLIENT_IMPL_DEFAULT;
        }
        if ((client = this.instantiateClient(className, url)) instanceof HttpClientPoolConfigurable) {
            PoolingHttpClientConnectionManager pool = CommonsHttpClientPoolCache.getPool(config);
            ((HttpClientPoolConfigurable)((Object)client)).setHttpClientPool(pool, config);
        } else {
            if (client instanceof TrustStoreConfigurable) {
                File truststore = config.truststore();
                String truststorePassword = config.truststorePassword();
                if (null != truststore && null != truststorePassword) {
                    ((TrustStoreConfigurable)((Object)client)).setTrustStore(truststore, truststorePassword);
                }
            } else {
                LOG.debug("{} is not capable of SSL/TLS communication", (Object)client.getClass().getName());
            }
            if (client instanceof KeyStoreConfigurable) {
                File keystore = config.keystore();
                String keystorePassword = config.keystorePassword();
                String keyPassword = config.keyPassword();
                if (null != keystore && null != keystorePassword && null != keyPassword) {
                    ((KeyStoreConfigurable)((Object)client)).setKeyStore(keystore, keystorePassword, keyPassword);
                }
            } else {
                LOG.debug("{} is not capable of Mutual authentication", (Object)client.getClass().getName());
            }
            if (client instanceof HostnameVerificationConfigurable) {
                ((HostnameVerificationConfigurable)((Object)client)).setHostnameVerification(config.hostnameVerification());
            } else {
                LOG.debug("{} is not capable of configurable SSL/TLS hostname verification", (Object)client.getClass().getName());
            }
        }
        String authString = config.authentication();
        AuthenticationType authenticationType = authType = authString == null ? null : AuthenticationType.valueOf(authString);
        if (client instanceof UsernamePasswordAuthenticateable) {
            if (this.isUserPasswordAuth(authType)) {
                String username = config.avaticaUser();
                String password = config.avaticaPassword();
                if (null != username && null != password) {
                    ((UsernamePasswordAuthenticateable)((Object)client)).setUsernamePassword(authType, username, password);
                } else {
                    LOG.debug("Username or password was null");
                }
            }
        } else {
            LOG.debug("{} is not capable of username/password authentication.", (Object)authType);
        }
        if (client instanceof GSSAuthenticateable) {
            if (AuthenticationType.SPNEGO == authType) {
                ((GSSAuthenticateable)((Object)client)).setGSSCredential(null);
            }
        } else {
            LOG.debug("{} is not capable of kerberos authentication.", (Object)authType);
        }
        if (null != kerberosUtil) {
            client = new DoAsAvaticaHttpClient(client, kerberosUtil);
        }
        return client;
    }

    private AvaticaHttpClient instantiateClient(String className, URL url) {
        AvaticaHttpClient client = null;
        Exception clientCreationException = null;
        try {
            Class<AvaticaHttpClient> clz = Class.forName(className).asSubclass(AvaticaHttpClient.class);
            Constructor<AvaticaHttpClient> constructor = clz.getConstructor(URL.class);
            client = constructor.newInstance(Objects.requireNonNull(url));
        }
        catch (Exception e) {
            clientCreationException = e;
        }
        if (client == null) {
            throw new RuntimeException("Failed to construct AvaticaHttpClient implementation " + className, clientCreationException);
        }
        return client;
    }

    private boolean isUserPasswordAuth(AuthenticationType authType) {
        return AuthenticationType.BASIC == authType || AuthenticationType.DIGEST == authType;
    }
}

