/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.tracing.Scope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracingConfigurationCoordinates
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Scope scope;
    private final String lb;

    private TracingConfigurationCoordinates(@NotNull Scope scope, @Nullable String lb) {
        this.scope = scope;
        this.lb = lb;
    }

    @NotNull
    public Scope scope() {
        return this.scope;
    }

    @Nullable
    public String label() {
        return this.lb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TracingConfigurationCoordinates that = (TracingConfigurationCoordinates)o;
        if (this.scope != that.scope) {
            return false;
        }
        return this.lb != null ? this.lb.equals(that.lb) : that.lb == null;
    }

    public int hashCode() {
        int res = this.scope != null ? this.scope.hashCode() : 0;
        res = 31 * res + (this.lb != null ? this.lb.hashCode() : 0);
        return res;
    }

    public String toString() {
        return S.toString(TracingConfigurationCoordinates.class, this);
    }

    public static class Builder {
        private final Scope scope;
        private String lb;

        public Builder(Scope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Null scope is not valid for tracing coordinates.");
            }
            this.scope = scope;
        }

        @NotNull
        public Builder withLabel(@Nullable String lb) {
            this.lb = lb;
            return this;
        }

        public TracingConfigurationCoordinates build() {
            return new TracingConfigurationCoordinates(this.scope, this.lb);
        }
    }
}

