/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.CliConfirmArgument;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.baseline.BaselineCommand;
import org.apache.ignite.internal.util.typedef.internal.U;

@CliConfirmArgument
@ArgumentGroup(value={"enabled", "timeout"}, optional=false)
public class BaselineAutoAdjustCommandArg
extends BaselineCommand.BaselineTaskArg {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(optional=true)
    @EnumDescription(names={"ENABLE", "DISABLE"}, descriptions={"Enable baseline auto adjust", "Disable baseline auto adjust"})
    private Enabled enabled;
    @Argument(optional=true, example="<timeoutMillis>", withoutPrefix=true)
    private Long timeout;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        U.writeEnum(out, this.enabled);
        out.writeObject(this.timeout);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        this.enabled = U.readEnum(in, Enabled.class);
        this.timeout = (Long)in.readObject();
    }

    public Enabled enabled() {
        return this.enabled;
    }

    public void enabled(Enabled enabled) {
        this.enabled = enabled;
    }

    public Long timeout() {
        return this.timeout;
    }

    public void timeout(Long timeout) {
        this.timeout = timeout;
    }

    public static enum Enabled {
        DISABLE,
        ENABLE;

    }
}

