/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.websession;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.websession.WebSession;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;

class WebSessionListener {
    WebSessionListener() {
    }

    public static EntryProcessor<String, WebSession, Void> newAttributeProcessor(Collection<T2<String, Object>> updates) {
        return new AttributesProcessor(updates);
    }

    private static class AttributesProcessor
    implements EntryProcessor<String, WebSession, Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private Collection<T2<String, Object>> updates;

        public AttributesProcessor() {
        }

        AttributesProcessor(Collection<T2<String, Object>> updates) {
            assert (updates != null);
            this.updates = updates;
        }

        public Void process(MutableEntry<String, WebSession> entry, Object ... args) {
            if (!entry.exists()) {
                return null;
            }
            WebSession ses0 = (WebSession)entry.getValue();
            WebSession ses = new WebSession(ses0.getId(), ses0);
            for (T2<String, Object> update : this.updates) {
                String name = (String)update.get1();
                assert (name != null);
                Object val = update.get2();
                if (val != null) {
                    ses.setAttribute(name, val);
                    continue;
                }
                ses.removeAttribute(name);
            }
            entry.setValue((Object)ses);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeCollection((ObjectOutput)out, this.updates);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.updates = U.readCollection((ObjectInput)in);
        }
    }
}

