/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.jta.reflect;

import java.lang.reflect.InvocationTargetException;
import javax.transaction.TransactionManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.jta.CacheTmLookup;
import org.apache.ignite.internal.util.typedef.internal.A;

public class CacheReflectionTmLookup
implements CacheTmLookup {
    private String cls;
    private String mtd;

    public CacheReflectionTmLookup() {
    }

    public CacheReflectionTmLookup(String cls, String mtd) {
        A.notNull((Object)cls, (String)"cls");
        A.notNull((Object)mtd, (String)"mtd");
        this.cls = cls;
        this.mtd = mtd;
    }

    public String getClassName() {
        return this.cls;
    }

    public void setClassName(String cls) {
        A.notNull((Object)cls, (String)"cls");
        this.cls = cls;
    }

    public String getMethodName() {
        return this.mtd;
    }

    public void setMethodName(String mtd) {
        A.notNull((Object)mtd, (String)"mtd");
        this.mtd = mtd;
    }

    @Override
    public TransactionManager getTm() throws IgniteException {
        assert (this.cls != null);
        assert (this.mtd != null);
        try {
            return (TransactionManager)Class.forName(this.cls).getMethod(this.mtd, new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IgniteException("Failed to find class: " + this.cls, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteException("Failed to find method: " + this.mtd, (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IgniteException("Failed to invoke method: " + this.mtd, (Throwable)e);
        }
    }
}

