/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.reflections.Reflections;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkProbe;
import org.yardstickframework.BenchmarkUtils;

public class BenchmarkLoader {
    private BenchmarkConfiguration cfg;
    private Reflections refs;

    public void initialize(BenchmarkConfiguration cfg) throws Exception {
        this.cfg = cfg;
        if (cfg.output() == null) {
            cfg.output(System.out);
        }
        if (cfg.error() == null) {
            cfg.error(System.err);
        }
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(cfg.propertiesFileName());){
            props.load(is);
        }
        catch (FileNotFoundException ignore) {
            BenchmarkUtils.println(cfg, "Framework configuration file was not found: " + cfg.propertiesFileName());
        }
        String propsEnv = System.getenv("PROPS_ENV");
        if (propsEnv != null) {
            try (FileInputStream is = new FileInputStream(propsEnv);){
                props.load(is);
            }
            catch (FileNotFoundException ignore) {
                BenchmarkUtils.println(cfg, "Benchmark configuration file pointed by PROPS_ENV was not found: " + propsEnv);
            }
        }
        if (props.getProperty("BENCHMARK_PACKAGES") != null && cfg.packages().isEmpty()) {
            String[] packagesArr = props.getProperty("BENCHMARK_PACKAGES").split(",");
            ArrayList<String> packagesLst = new ArrayList<String>(packagesArr.length);
            for (String pck : packagesArr) {
                if ((pck = pck.trim()).isEmpty()) continue;
                packagesLst.add(pck);
            }
            cfg.packages(packagesLst);
        }
        LinkedHashSet<String> allPackages = new LinkedHashSet<String>();
        if (cfg.packages() != null) {
            allPackages.addAll(cfg.packages());
        }
        this.refs = new Reflections((Object[])allPackages.toArray(new String[allPackages.size()]));
        HashMap<String, String> customProps = new HashMap<String, String>(props.size());
        block31: for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            switch (key) {
                case "BENCHMARK_DEFAULT_PROBES": {
                    if (!cfg.defaultProbeClassNames().isEmpty()) continue block31;
                    String[] clsArr = val.split(",");
                    ArrayList<String> probes = new ArrayList<String>(clsArr.length);
                    for (String clsName : clsArr) {
                        if ((clsName = clsName.trim()).isEmpty()) continue;
                        probes.add(clsName);
                    }
                    cfg.defaultProbeClassNames(probes);
                    break;
                }
                case "BENCHMARK_WRITER": {
                    String writerClsName;
                    if (cfg.probeWriterClassName() != null || (writerClsName = val.trim()).isEmpty()) continue block31;
                    cfg.probeWriterClassName(writerClsName);
                    break;
                }
                default: {
                    customProps.put(key, val);
                }
            }
        }
        cfg.customProperties(customProps);
    }

    public Collection<BenchmarkProbe> loadProbes() throws Exception {
        ArrayList<BenchmarkProbe> probes = new ArrayList<BenchmarkProbe>(this.cfg.defaultProbeClassNames().size());
        for (String probeClsName : this.cfg.defaultProbeClassNames()) {
            BenchmarkProbe probe = this.loadClass(BenchmarkProbe.class, probeClsName);
            if (probe != null) {
                probes.add(probe);
                continue;
            }
            BenchmarkUtils.println(this.cfg, "Failed to load probe: " + probeClsName);
        }
        return probes;
    }

    public <T> T loadClass(Class<T> cls, String name) throws Exception {
        Class implCls;
        String fqName;
        Set classes = this.refs.getSubTypesOf(cls);
        HashMap<String, String> simpleNames = new HashMap<String, String>(classes.size());
        HashMap<String, Class> fqNames = new HashMap<String, Class>(classes.size());
        ArrayList<String> duplicates = null;
        for (Class c : classes) {
            if (Modifier.isAbstract(c.getModifiers())) continue;
            if (!simpleNames.containsKey(c.getSimpleName())) {
                simpleNames.put(c.getSimpleName(), c.getName());
            } else {
                if (duplicates == null) {
                    duplicates = new ArrayList<String>();
                }
                duplicates.add(c.getName());
            }
            fqNames.put(c.getName(), c);
        }
        if (duplicates != null) {
            BenchmarkUtils.println(this.cfg, "Duplicate simple class names detected (use fully-qualified names for execution): ");
            for (String duplicate : duplicates) {
                BenchmarkUtils.println(this.cfg, "\t" + duplicate);
            }
        }
        if ((fqName = (String)simpleNames.get(name)) == null) {
            fqName = name;
        }
        if ((implCls = (Class)fqNames.get(fqName)) == null) {
            return null;
        }
        return implCls.newInstance();
    }
}

