/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridClientHandshakeResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.client.message.GridClientPingPacket;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterRequest;
import org.apache.ignite.internal.processors.rest.client.message.GridRouterResponse;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridClientPacketType;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridMemcachedMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.util.GridByteArrayList;
import org.apache.ignite.internal.util.GridClientByteUtils;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

public class GridTcpRestParser
implements GridNioParser {
    private final Marshaller marsh;
    private final boolean routerClient;

    public GridTcpRestParser(boolean routerClient) {
        this(routerClient, new JdkMarshaller());
    }

    public GridTcpRestParser(boolean routerClient, Marshaller marsh) {
        this.routerClient = routerClient;
        this.marsh = marsh;
    }

    @Override
    @Nullable
    public GridClientMessage decode(GridNioSession ses, ByteBuffer buf) throws IOException, IgniteCheckedException {
        GridClientPacketType type;
        ParserState state = (ParserState)ses.removeMeta(GridNioSessionMetaKey.PARSER_STATE.ordinal());
        if (state == null) {
            state = new ParserState();
        }
        if ((type = state.packetType()) == null) {
            byte hdr = buf.get(buf.position());
            switch (hdr) {
                case -128: {
                    state.packet(new GridMemcachedMessage());
                    state.packetType(GridClientPacketType.MEMCACHE);
                    break;
                }
                case 42: {
                    state.packetType(GridClientPacketType.REDIS);
                    break;
                }
                case -112: {
                    buf.get();
                    state.packetType(GridClientPacketType.IGNITE);
                    break;
                }
                case -111: {
                    buf.get();
                    state.packetType(GridClientPacketType.IGNITE_HANDSHAKE);
                    break;
                }
                case -110: {
                    buf.get();
                    state.packetType(GridClientPacketType.IGNITE_HANDSHAKE_RES);
                    break;
                }
                default: {
                    throw new IOException("Failed to parse incoming packet (invalid packet start) [ses=" + ses + ", b=" + Integer.toHexString(hdr & 0xFF) + "]");
                }
            }
        }
        GridClientMessage res = null;
        switch (state.packetType()) {
            case MEMCACHE: {
                res = this.parseMemcachePacket(ses, buf, state);
                break;
            }
            case REDIS: {
                res = GridTcpRestParser.parseRedisPacket(buf, state);
                break;
            }
            case IGNITE_HANDSHAKE: {
                res = this.parseHandshake(buf, state);
                break;
            }
            case IGNITE_HANDSHAKE_RES: {
                if (!buf.hasRemaining()) break;
                res = new GridClientHandshakeResponse(buf.get());
                break;
            }
            case IGNITE: {
                res = this.parseCustomPacket(ses, buf, state);
            }
        }
        if (res == null) {
            ses.addMeta(GridNioSessionMetaKey.PARSER_STATE.ordinal(), state);
        }
        return res;
    }

    @Override
    public ByteBuffer encode(GridNioSession ses, Object msg0) throws IOException, IgniteCheckedException {
        assert (msg0 != null);
        GridClientMessage msg = (GridClientMessage)msg0;
        if (msg instanceof GridMemcachedMessage) {
            return this.encodeMemcache((GridMemcachedMessage)msg);
        }
        if (msg instanceof GridRedisMessage) {
            return ((GridRedisMessage)msg).getResponse();
        }
        if (msg instanceof GridClientPingPacket) {
            return ByteBuffer.wrap(GridClientPingPacket.PING_PACKET);
        }
        if (msg instanceof GridClientHandshakeRequest) {
            byte[] bytes = ((GridClientHandshakeRequest)msg).rawBytes();
            ByteBuffer buf = ByteBuffer.allocate(bytes.length + 1);
            buf.put((byte)-111);
            buf.put(bytes);
            buf.flip();
            return buf;
        }
        if (msg instanceof GridClientHandshakeResponse) {
            return ByteBuffer.wrap(new byte[]{-110, ((GridClientHandshakeResponse)msg).resultCode()});
        }
        if (msg instanceof GridRouterRequest) {
            byte[] body = ((GridRouterRequest)msg).body();
            ByteBuffer buf = ByteBuffer.allocate(45 + body.length);
            buf.put((byte)-112);
            buf.putInt(40 + body.length);
            buf.putLong(msg.requestId());
            buf.put(U.uuidToBytes(msg.clientId()));
            buf.put(U.uuidToBytes(msg.destinationId()));
            buf.put(body);
            buf.flip();
            return buf;
        }
        GridClientMarshaller marsh = this.marshaller(ses);
        ByteBuffer res = marsh.marshal(msg, 45);
        ByteBuffer slice = res.slice();
        slice.put((byte)-112);
        slice.putInt(res.remaining() - 5);
        slice.putLong(msg.requestId());
        slice.put(U.uuidToBytes(msg.clientId()));
        slice.put(U.uuidToBytes(msg.destinationId()));
        return res;
    }

    static GridClientMessage parseRedisPacket(ByteBuffer buf, ParserState state) throws IOException, IgniteCheckedException {
        GridRedisMessage msg;
        int arrLen;
        int i;
        assert (state.packetType() == GridClientPacketType.REDIS);
        if (state.buffer().size() > 0) {
            byte[] tail = state.buffer().toByteArray();
            buf = ByteBuffer.allocate(tail.length + buf.remaining()).put(tail).put(buf);
            buf.rewind();
        }
        if (state.packet() == null) {
            i = 0;
            if (!GridRedisProtocolParser.ensureArrayStart(buf)) {
                GridTcpRestParser.saveTail(state.buffer(), buf);
                return null;
            }
            arrLen = GridRedisProtocolParser.readInt(buf);
            if (arrLen == -2) {
                buf.rewind();
                GridTcpRestParser.saveTail(state.buffer(), buf);
                return null;
            }
            msg = new GridRedisMessage(arrLen);
            state.packet(msg);
        } else {
            msg = (GridRedisMessage)state.packet();
            i = msg.messageSize();
            arrLen = msg.fullLength();
        }
        while (i < arrLen) {
            int pos = buf.position();
            String str = GridRedisProtocolParser.readBulkStr(buf);
            if (str == null) {
                buf.position(pos);
                GridTcpRestParser.saveTail(state.buffer(), buf);
                return null;
            }
            msg.append(str);
            ++i;
        }
        return msg;
    }

    private static void saveTail(ByteArrayOutputStream os, ByteBuffer buf) throws IOException {
        os.reset();
        if (!buf.hasRemaining()) {
            return;
        }
        if (buf.hasArray()) {
            os.write(buf.array(), buf.position(), buf.remaining());
            buf.position(buf.position() + buf.remaining());
        } else {
            byte[] data = new byte[buf.remaining()];
            buf.get(data);
            os.write(data);
        }
    }

    @Nullable
    private GridClientMessage parseMemcachePacket(GridNioSession ses, ByteBuffer buf, ParserState state) throws IOException, IgniteCheckedException {
        assert (state.packetType() == GridClientPacketType.MEMCACHE);
        assert (state.packet() != null);
        assert (state.packet() instanceof GridMemcachedMessage);
        GridMemcachedMessage req = (GridMemcachedMessage)state.packet();
        ByteArrayOutputStream tmp = state.buffer();
        int i = state.index();
        while (buf.remaining() > 0) {
            byte b = buf.get();
            if (i == 0) {
                req.requestFlag(b);
            } else if (i == 1) {
                req.operationCode(b);
            } else if (i == 2 || i == 3) {
                tmp.write(b);
                if (i == 3) {
                    req.keyLength(U.bytesToShort(tmp.toByteArray(), 0));
                    tmp.reset();
                }
            } else if (i == 4) {
                req.extrasLength(b);
            } else if (i >= 8 && i <= 11) {
                tmp.write(b);
                if (i == 11) {
                    req.totalLength(U.bytesToInt(tmp.toByteArray(), 0));
                    tmp.reset();
                }
            } else if (i >= 12 && i <= 15) {
                tmp.write(b);
                if (i == 15) {
                    req.opaque(tmp.toByteArray());
                    tmp.reset();
                }
            } else if (i >= 24 && i < 24 + req.extrasLength()) {
                tmp.write(b);
                if (i == 24 + req.extrasLength() - 1) {
                    req.extras(tmp.toByteArray());
                    tmp.reset();
                }
            } else if (i >= 24 + req.extrasLength() && i < 24 + req.extrasLength() + req.keyLength()) {
                tmp.write(b);
                if (i == 24 + req.extrasLength() + req.keyLength() - 1) {
                    req.key(tmp.toByteArray());
                    tmp.reset();
                }
            } else if (i >= 24 + req.extrasLength() + req.keyLength() && i < 24 + req.totalLength()) {
                tmp.write(b);
                if (i == 24 + req.totalLength() - 1) {
                    req.value(tmp.toByteArray());
                    tmp.reset();
                }
            }
            if (i == 24 + req.totalLength() - 1) {
                return this.assemble(ses, req);
            }
            ++i;
        }
        state.index(i);
        return null;
    }

    @Nullable
    private GridClientMessage parseHandshake(ByteBuffer buf, ParserState state) {
        int rem;
        assert (state.packetType() == GridClientPacketType.IGNITE_HANDSHAKE);
        int idx = state.index();
        GridClientHandshakeRequest packet = (GridClientHandshakeRequest)state.packet();
        if (packet == null) {
            packet = new GridClientHandshakeRequest();
            state.packet(packet);
        }
        if ((rem = buf.remaining()) > 0) {
            byte[] bbuf = new byte[5];
            int nRead = Math.min(rem, bbuf.length);
            buf.get(bbuf, 0, nRead);
            int nAvailable = nRead;
            if (idx < 4) {
                int len = Math.min(nRead, 4 - idx);
                packet.putBytes(bbuf, idx, len);
                state.index(idx += len);
                nAvailable -= len;
            }
            assert (idx <= 4) : "Wrong idx: " + idx;
            assert (nAvailable == 0 || nAvailable == 1) : "Wrong nav: " + nAvailable;
            if (idx == 4 && nAvailable > 0) {
                return packet;
            }
        }
        return null;
    }

    @Nullable
    private GridClientMessage parseCustomPacket(GridNioSession ses, ByteBuffer buf, ParserState state) throws IOException, IgniteCheckedException {
        assert (state.packetType() == GridClientPacketType.IGNITE);
        assert (state.packet() == null);
        ByteArrayOutputStream tmp = state.buffer();
        int len = state.index();
        if (buf.remaining() > 0) {
            byte[] hdrBytes;
            byte[] lenBytes;
            if (len == 0 && (lenBytes = this.statefulRead(buf, tmp, 4)) != null) {
                len = U.bytesToInt(lenBytes, 0);
                if (len == 0) {
                    return GridClientPingPacket.PING_MESSAGE;
                }
                if (len < 0) {
                    throw new IOException("Failed to parse incoming packet (invalid packet length) [ses=" + ses + ", len=" + len + "]");
                }
                state.index(len);
            }
            if (len > 0 && state.header() == null && (hdrBytes = this.statefulRead(buf, tmp, 40)) != null) {
                long reqId = GridClientByteUtils.bytesToLong(hdrBytes, 0);
                UUID clientId = GridClientByteUtils.bytesToUuid(hdrBytes, 8);
                UUID destId = GridClientByteUtils.bytesToUuid(hdrBytes, 24);
                state.header(new HeaderData(reqId, clientId, destId));
            }
            if (len > 0 && state.header() != null) {
                int packetSize = len - 40;
                if (tmp.size() + buf.remaining() >= packetSize) {
                    if (buf.remaining() > 0) {
                        byte[] bodyBytes = new byte[packetSize - tmp.size()];
                        buf.get(bodyBytes);
                        tmp.write(bodyBytes);
                    }
                    return this.parseClientMessage(ses, state);
                }
                this.copyRemaining(buf, tmp);
            }
        }
        return null;
    }

    @Nullable
    private byte[] statefulRead(ByteBuffer buf, ByteArrayOutputStream intBuf, int size) throws IOException {
        if (intBuf.size() + buf.remaining() >= size) {
            int off = 0;
            byte[] bytes = new byte[size];
            if (intBuf.size() > 0) {
                assert (intBuf.size() < size);
                byte[] tmpBytes = intBuf.toByteArray();
                System.arraycopy(tmpBytes, 0, bytes, 0, tmpBytes.length);
                off = intBuf.size();
                intBuf.reset();
            }
            buf.get(bytes, off, size - off);
            return bytes;
        }
        this.copyRemaining(buf, intBuf);
        return null;
    }

    private void copyRemaining(ByteBuffer src, OutputStream dest) throws IOException {
        byte[] b = new byte[src.remaining()];
        src.get(b);
        dest.write(b);
    }

    protected GridClientMessage parseClientMessage(GridNioSession ses, ParserState state) throws IOException, IgniteCheckedException {
        GridClientMessage msg;
        if (this.routerClient) {
            msg = new GridRouterResponse(state.buffer().toByteArray(), state.header().reqId(), state.header().clientId(), state.header().destinationId());
        } else {
            GridClientMarshaller marsh = this.marshaller(ses);
            msg = (GridClientMessage)marsh.unmarshal(state.buffer().toByteArray());
            msg.requestId(state.header().reqId());
            msg.clientId(state.header().clientId());
            msg.destinationId(state.header().destinationId());
        }
        return msg;
    }

    private ByteBuffer encodeMemcache(GridMemcachedMessage msg) throws IgniteCheckedException {
        GridByteArrayList res = new GridByteArrayList(24);
        int keyLen = 0;
        int keyFlags = 0;
        if (msg.key() != null) {
            ByteArrayOutputStream rawKey = new ByteArrayOutputStream();
            keyFlags = this.encodeObj(msg.key(), rawKey);
            msg.key(rawKey.toByteArray());
            keyLen = rawKey.size();
        }
        int dataLen = 0;
        int valFlags = 0;
        if (msg.value() != null) {
            ByteArrayOutputStream rawVal = new ByteArrayOutputStream();
            valFlags = this.encodeObj(msg.value(), rawVal);
            msg.value(rawVal.toByteArray());
            dataLen = rawVal.size();
        }
        int flagsLen = 0;
        if (msg.addFlags()) {
            flagsLen = 4;
        }
        res.add((byte)-127);
        res.add(msg.operationCode());
        res.add((short)keyLen);
        res.add((byte)flagsLen);
        res.add((byte)0);
        res.add((short)msg.status());
        res.add(keyLen + flagsLen + dataLen);
        res.add(msg.opaque(), 0, msg.opaque().length);
        res.add(0L);
        assert (res.size() == 24);
        if (flagsLen > 0) {
            res.add((short)keyFlags);
            res.add((short)valFlags);
        }
        assert (msg.key() == null || msg.key() instanceof byte[]);
        assert (msg.value() == null || msg.value() instanceof byte[]);
        if (keyLen > 0) {
            res.add((byte[])msg.key(), 0, ((byte[])msg.key()).length);
        }
        if (dataLen > 0) {
            res.add((byte[])msg.value(), 0, ((byte[])msg.value()).length);
        }
        return ByteBuffer.wrap(res.entireArray());
    }

    private GridClientMessage assemble(GridNioSession ses, GridMemcachedMessage req) throws IOException, IgniteCheckedException {
        byte[] extras = req.extras();
        if (req.key() != null || req.value() != null) {
            short keyFlags = 0;
            short valFlags = 0;
            if (req.hasFlags()) {
                if (extras == null || extras.length < 4) {
                    throw new IOException("Failed to parse incoming packet (flags required for command) [ses=" + ses + ", opCode=" + Integer.toHexString(req.operationCode() & 0xFF) + "]");
                }
                keyFlags = U.bytesToShort(extras, 0);
                valFlags = U.bytesToShort(extras, 2);
            }
            if (req.key() != null) {
                assert (req.key() instanceof byte[]);
                byte[] rawKey = (byte[])req.key();
                req.key(this.decodeObj(keyFlags, rawKey));
            }
            if (req.value() != null) {
                assert (req.value() instanceof byte[]);
                byte[] rawVal = (byte[])req.value();
                req.value(this.decodeObj(valFlags, rawVal));
            }
        }
        if (req.hasExpiration()) {
            if (extras == null || extras.length < 8) {
                throw new IOException("Failed to parse incoming packet (expiration value required for command) [ses=" + ses + ", opCode=" + Integer.toHexString(req.operationCode() & 0xFF) + "]");
            }
            req.expiration((long)U.bytesToInt(extras, 4) & 0xFFFFFFFFL);
        }
        if (req.hasInitial()) {
            if (extras == null || extras.length < 16) {
                throw new IOException("Failed to parse incoming packet (initial value required for command) [ses=" + ses + ", opCode=" + Integer.toHexString(req.operationCode() & 0xFF) + "]");
            }
            req.initial(U.bytesToLong(extras, 8));
        }
        if (req.hasDelta()) {
            if (extras == null || extras.length < 8) {
                throw new IOException("Failed to parse incoming packet (delta value required for command) [ses=" + ses + ", opCode=" + Integer.toHexString(req.operationCode() & 0xFF) + "]");
            }
            req.delta(U.bytesToLong(extras, 0));
        }
        if (extras != null) {
            int len = 4;
            if (req.hasExpiration()) {
                len += 4;
            }
            if (req.hasDelta()) {
                len += 8;
            }
            if (req.hasInitial()) {
                len += 8;
            }
            if (extras.length - len > 0) {
                byte[] cacheName = new byte[extras.length - len];
                U.arrayCopy(extras, len, cacheName, 0, extras.length - len);
                req.cacheName(new String(cacheName, StandardCharsets.UTF_8));
            }
        }
        return req;
    }

    private Object decodeObj(short flags, byte[] bytes) throws IgniteCheckedException {
        assert (bytes != null);
        if ((flags & 1) != 0) {
            return U.unmarshal(this.marsh, bytes, null);
        }
        int masked = flags & 0xFF00;
        switch (masked) {
            case 256: {
                return bytes[0] == 49;
            }
            case 512: {
                return U.bytesToInt(bytes, 0);
            }
            case 768: {
                return U.bytesToLong(bytes, 0);
            }
            case 1024: {
                return new Date(U.bytesToLong(bytes, 0));
            }
            case 1280: {
                return bytes[0];
            }
            case 1536: {
                return Float.valueOf(Float.intBitsToFloat(U.bytesToInt(bytes, 0)));
            }
            case 1792: {
                return Double.longBitsToDouble(U.bytesToLong(bytes, 0));
            }
            case 2048: {
                return bytes;
            }
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private int encodeObj(Object obj, ByteArrayOutputStream out) throws IgniteCheckedException {
        int flags = 0;
        byte[] data = null;
        if (obj instanceof String) {
            data = ((String)obj).getBytes(StandardCharsets.UTF_8);
        } else if (obj instanceof Boolean) {
            data = new byte[]{(byte)((Boolean)obj != false ? 49 : 48)};
            flags |= 0x100;
        } else if (obj instanceof Integer) {
            data = U.intToBytes((Integer)obj);
            flags |= 0x200;
        } else if (obj instanceof Long) {
            data = U.longToBytes((Long)obj);
            flags |= 0x300;
        } else if (obj instanceof Date) {
            data = U.longToBytes(((Date)obj).getTime());
            flags |= 0x400;
        } else if (obj instanceof Byte) {
            data = new byte[]{(Byte)obj};
            flags |= 0x500;
        } else if (obj instanceof Float) {
            data = U.intToBytes(Float.floatToIntBits(((Float)obj).floatValue()));
            flags |= 0x600;
        } else if (obj instanceof Double) {
            data = U.longToBytes(Double.doubleToLongBits((Double)obj));
            flags |= 0x700;
        } else if (obj instanceof byte[]) {
            data = (byte[])obj;
            flags |= 0x800;
        } else {
            U.marshal(this.marsh, obj, out);
            flags |= 1;
        }
        if (data != null) {
            out.write(data, 0, data.length);
        }
        return flags;
    }

    protected GridClientMarshaller marshaller(GridNioSession ses) {
        GridClientMarshaller marsh = (GridClientMarshaller)ses.meta(GridNioSessionMetaKey.MARSHALLER.ordinal());
        assert (marsh != null);
        return marsh;
    }

    public String toString() {
        return S.toString(GridTcpRestParser.class, this);
    }

    protected static class HeaderData {
        private final long reqId;
        private final UUID clientId;
        private final UUID destId;

        private HeaderData(long reqId, UUID clientId, UUID destId) {
            this.reqId = reqId;
            this.clientId = clientId;
            this.destId = destId;
        }

        public long reqId() {
            return this.reqId;
        }

        public UUID clientId() {
            return this.clientId;
        }

        public UUID destinationId() {
            return this.destId;
        }
    }

    protected static class ParserState {
        private int idx;
        private ByteArrayOutputStream buf = new ByteArrayOutputStream();
        private GridClientMessage packet;
        private GridClientPacketType packetType;
        private HeaderData hdr;

        protected ParserState() {
        }

        public int index() {
            return this.idx;
        }

        public void index(int idx) {
            this.idx = idx;
        }

        public ByteArrayOutputStream buffer() {
            return this.buf;
        }

        @Nullable
        public GridClientMessage packet() {
            return this.packet;
        }

        public void packet(GridClientMessage packet) {
            assert (this.packet == null);
            this.packet = packet;
        }

        public GridClientPacketType packetType() {
            return this.packetType;
        }

        public void packetType(GridClientPacketType packetType) {
            this.packetType = packetType;
        }

        public HeaderData header() {
            return this.hdr;
        }

        public void header(HeaderData hdr) {
            this.hdr = hdr;
        }

        public String toString() {
            return S.toString(ParserState.class, this);
        }
    }
}

