/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.util.GridUnsafe;

public class PlatformInputStreamImpl
implements PlatformInputStream {
    private final PlatformMemory mem;
    private long data;
    private int len;
    private int pos;
    private byte[] dataCopy;

    public PlatformInputStreamImpl(PlatformMemory mem) {
        this.mem = mem;
        this.data = mem.data();
        this.len = mem.length();
    }

    @Override
    public byte readByte() {
        this.ensureEnoughData(1);
        return GridUnsafe.getByte(this.data + (long)this.pos++);
    }

    @Override
    public byte[] readByteArray(int cnt) {
        byte[] res = new byte[cnt];
        this.copyAndShift(res, GridUnsafe.BYTE_ARR_OFF, cnt);
        return res;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    @Override
    public boolean[] readBooleanArray(int cnt) {
        boolean[] res = new boolean[cnt];
        this.copyAndShift(res, GridUnsafe.BOOLEAN_ARR_OFF, cnt);
        return res;
    }

    @Override
    public short readShort() {
        this.ensureEnoughData(2);
        short res = GridUnsafe.getShort(this.data + (long)this.pos);
        this.shift(2);
        return res;
    }

    @Override
    public short[] readShortArray(int cnt) {
        int len = cnt << 1;
        short[] res = new short[cnt];
        this.copyAndShift(res, GridUnsafe.SHORT_ARR_OFF, len);
        return res;
    }

    @Override
    public char readChar() {
        this.ensureEnoughData(2);
        char res = GridUnsafe.getChar(this.data + (long)this.pos);
        this.shift(2);
        return res;
    }

    @Override
    public char[] readCharArray(int cnt) {
        int len = cnt << 1;
        char[] res = new char[cnt];
        this.copyAndShift(res, GridUnsafe.CHAR_ARR_OFF, len);
        return res;
    }

    @Override
    public int readInt() {
        this.ensureEnoughData(4);
        int res = GridUnsafe.getInt(this.data + (long)this.pos);
        this.shift(4);
        return res;
    }

    @Override
    public byte readBytePositioned(int pos) {
        int delta = pos + 1 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return GridUnsafe.getByte(this.data + (long)pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        int delta = pos + 2 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return GridUnsafe.getShort(this.data + (long)pos);
    }

    @Override
    public int readIntPositioned(int pos) {
        int delta = pos + 4 - this.pos;
        if (delta > 0) {
            this.ensureEnoughData(delta);
        }
        return GridUnsafe.getInt(this.data + (long)pos);
    }

    @Override
    public int[] readIntArray(int cnt) {
        int len = cnt << 2;
        int[] res = new int[cnt];
        this.copyAndShift(res, GridUnsafe.INT_ARR_OFF, len);
        return res;
    }

    @Override
    public float readFloat() {
        this.ensureEnoughData(4);
        float res = GridUnsafe.getFloat(this.data + (long)this.pos);
        this.shift(4);
        return res;
    }

    @Override
    public float[] readFloatArray(int cnt) {
        int len = cnt << 2;
        float[] res = new float[cnt];
        this.copyAndShift(res, GridUnsafe.FLOAT_ARR_OFF, len);
        return res;
    }

    @Override
    public long readLong() {
        this.ensureEnoughData(8);
        long res = GridUnsafe.getLong(this.data + (long)this.pos);
        this.shift(8);
        return res;
    }

    @Override
    public long[] readLongArray(int cnt) {
        int len = cnt << 3;
        long[] res = new long[cnt];
        this.copyAndShift(res, GridUnsafe.LONG_ARR_OFF, len);
        return res;
    }

    @Override
    public double readDouble() {
        this.ensureEnoughData(8);
        double res = GridUnsafe.getDouble(this.data + (long)this.pos);
        this.shift(8);
        return res;
    }

    @Override
    public double[] readDoubleArray(int cnt) {
        int len = cnt << 3;
        double[] res = new double[cnt];
        this.copyAndShift(res, GridUnsafe.DOUBLE_ARR_OFF, len);
        return res;
    }

    @Override
    public int read(byte[] arr, int off, int len) {
        if (len > this.remaining()) {
            len = this.remaining();
        }
        this.copyAndShift(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
        return len;
    }

    @Override
    public int remaining() {
        return this.len - this.pos;
    }

    @Override
    public int capacity() {
        return this.len;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public void position(int pos) {
        if (pos > this.len) {
            throw new IgniteException("Position is out of bounds: " + pos);
        }
        this.pos = pos;
    }

    @Override
    public byte[] array() {
        return this.arrayCopy();
    }

    @Override
    public byte[] arrayCopy() {
        if (this.dataCopy == null) {
            this.dataCopy = new byte[this.len];
            GridUnsafe.copyOffheapHeap(this.data, this.dataCopy, GridUnsafe.BYTE_ARR_OFF, this.dataCopy.length);
        }
        return this.dataCopy;
    }

    @Override
    public long offheapPointer() {
        return 0L;
    }

    @Override
    public long rawOffheapPointer() {
        return 0L;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public void synchronize() {
        this.data = this.mem.data();
        this.len = this.mem.length();
    }

    private void ensureEnoughData(int cnt) {
        if (this.remaining() < cnt) {
            throw new IgniteException("Not enough data to read the value [position=" + this.pos + ", requiredBytes=" + cnt + ", remainingBytes=" + this.remaining() + "]");
        }
    }

    private void copyAndShift(Object target, long off, int cnt) {
        this.ensureEnoughData(cnt);
        GridUnsafe.copyOffheapHeap(this.data + (long)this.pos, target, off, cnt);
        this.shift(cnt);
    }

    private void shift(int cnt) {
        this.pos += cnt;
        assert (this.pos <= this.len);
    }
}

