/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tracing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.CommandRegistryImpl;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetAllCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetAllCommandArg;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationGetCommandArg;
import org.apache.ignite.internal.management.tracing.TracingConfigurationResetAllCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationResetCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationSetCommand;
import org.apache.ignite.internal.management.tracing.TracingConfigurationTask;
import org.apache.ignite.internal.management.tracing.TracingConfigurationTaskResult;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class TracingConfigurationCommand
extends CommandRegistryImpl<TracingConfigurationCommandArg, TracingConfigurationTaskResult>
implements ComputeCommand<TracingConfigurationCommandArg, TracingConfigurationTaskResult> {
    public TracingConfigurationCommand() {
        super(new TracingConfigurationGetAllCommand(), new TracingConfigurationGetCommand(), new TracingConfigurationResetAllCommand(), new TracingConfigurationResetCommand(), new TracingConfigurationSetCommand());
    }

    @Override
    public String description() {
        return "Print tracing configuration";
    }

    @Override
    public Class<TracingConfigurationGetAllCommandArg> argClass() {
        return TracingConfigurationGetAllCommandArg.class;
    }

    @Override
    public Class<TracingConfigurationTask> taskClass() {
        return TracingConfigurationTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, TracingConfigurationCommandArg arg) {
        return CommandUtils.coordinatorOrNull(nodes);
    }

    @Override
    public void printResult(TracingConfigurationCommandArg arg, TracingConfigurationTaskResult res, Consumer<String> printer) {
        res.print(printer);
    }

    public static class TracingConfigurationResetCommandArg
    extends TracingConfigurationGetCommandArg {
        private static final long serialVersionUID = 0L;
    }

    public static class TracingConfigurationResetAllCommandArg
    extends TracingConfigurationGetAllCommandArg {
        private static final long serialVersionUID = 0L;
    }

    public static abstract class TracingConfigurationCommandArg
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
        }

        @Override
        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

