/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.hop.pipeline.transforms.dorisbulkloader;

import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;

@SuppressWarnings("java:S1104")
public class DorisBulkLoaderData extends BaseTransformData implements ITransformData {
  public IRowMeta inputRowMeta;

  /** Index of doris http body field in upstream fields */
  private int indexOfBodyField;

  /** doris stream load client */
  public DorisStreamLoad dorisStreamLoad;

  public DorisBulkLoaderData() {
    super();
    this.indexOfBodyField = -1;
    this.dorisStreamLoad = null;
  }

  public int getIndexOfBodyField() {
    return indexOfBodyField;
  }

  public void setIndexOfBodyField(String bodyField) {
    if (!Utils.isEmpty(bodyField)) {
      indexOfBodyField = this.inputRowMeta.indexOfValue(bodyField);
    }
  }
}
