/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class BigIntegerArrayByteBufferConverter
implements TypeConverter<BigInteger[], ByteBuffer> {
    private static final long serialVersionUID = 1225964406998563456L;

    @Override
    public ByteBuffer toDatastoreType(BigInteger[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromBigIntegerArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public BigInteger[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return ArrayConversionHelper.getBigIntegerArrayFromByteArray(datastoreValue.array());
    }
}

