/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFPartition;

public class Range {
    int start;
    int end;
    PTFPartition p;
    private final boolean optimized;

    public Range(int start, int end, PTFPartition p, boolean optimized) {
        this.start = start;
        this.end = end;
        this.p = p;
        this.optimized = optimized;
    }

    public Range(int start, int end, PTFPartition p) {
        this(start, end, p, false);
    }

    public PTFPartition.PTFPartitionIterator<Object> iterator() {
        return this.p.range(this.start, this.end, this.optimized);
    }

    public int getDiff(Range prevRange) {
        return this.start - prevRange.start + this.end - prevRange.end;
    }

    public int getSize() {
        return this.end - this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return String.format("Range: %d-%d, size: %d", this.start, this.end, this.getSize());
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.end;
        if (this.p != null) {
            hash = 31 * hash + this.p.hashCode();
        }
        return 31 * hash + this.start;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.p == other.p;
    }

    public int compareTo(Range other) {
        return this.getSize() == other.getSize() ? this.getStart() - other.getStart() : this.getSize() - other.getSize();
    }
}

