/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.LevelOrderWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.optimizer.lineage.OpProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    private final Predicate<ParseContext> statementFilter;

    public static Generator fromConf(HiveConf conf) {
        return new Generator(Generator.createFilterPredicateFromConf((Configuration)conf));
    }

    static Predicate<ParseContext> createFilterPredicateFromConf(Configuration conf) {
        HashSet<LineageInfoFilter> operations = new HashSet<LineageInfoFilter>();
        boolean noneSpecified = false;
        for (String valueText : conf.getTrimmedStringCollection(HiveConf.ConfVars.HIVE_LINEAGE_STATEMENT_FILTER.varname)) {
            LineageInfoFilter enumValue = (LineageInfoFilter)EnumUtils.getEnumIgnoreCase(LineageInfoFilter.class, (String)valueText);
            if (enumValue == null) {
                throw new EnumConstantNotPresentException(LineageInfoFilter.class, valueText);
            }
            if (LineageInfoFilter.NONE == enumValue) {
                noneSpecified = true;
                continue;
            }
            operations.add(enumValue);
        }
        if (noneSpecified) {
            if (!operations.isEmpty()) {
                throw new IllegalArgumentException("No other value can be specified when " + LineageInfoFilter.NONE.name() + " is present!");
            }
            return parseContext -> false;
        }
        return parseContext -> operations.stream().anyMatch(lineageInfoFilter -> lineageInfoFilter.predicate.test((ParseContext)parseContext));
    }

    public Generator(Predicate<ParseContext> statementFilter) {
        this.statementFilter = statementFilter;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (!this.statementFilter.test(pctx)) {
            LOG.debug("Not evaluating lineage");
            return pctx;
        }
        LineageCtx.Index index = pctx.getQueryState().getLineageState().getIndex();
        if (index == null) {
            index = new LineageCtx.Index();
        }
        long sTime = System.currentTimeMillis();
        LineageCtx lCtx = new LineageCtx(pctx, index);
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), OpProcFactory.getTSProc());
        opRules.put(new RuleRegExp("R2", ScriptOperator.getOperatorName() + "%"), OpProcFactory.getTransformProc());
        opRules.put(new RuleRegExp("R3", UDTFOperator.getOperatorName() + "%"), OpProcFactory.getTransformProc());
        opRules.put(new RuleRegExp("R4", SelectOperator.getOperatorName() + "%"), OpProcFactory.getSelProc());
        opRules.put(new RuleRegExp("R5", GroupByOperator.getOperatorName() + "%"), OpProcFactory.getGroupByProc());
        opRules.put(new RuleRegExp("R6", UnionOperator.getOperatorName() + "%"), OpProcFactory.getUnionProc());
        opRules.put(new RuleRegExp("R7", CommonJoinOperator.getOperatorName() + "%|" + MapJoinOperator.getOperatorName() + "%"), OpProcFactory.getJoinProc());
        opRules.put(new RuleRegExp("R8", ReduceSinkOperator.getOperatorName() + "%"), OpProcFactory.getReduceSinkProc());
        opRules.put(new RuleRegExp("R9", LateralViewJoinOperator.getOperatorName() + "%"), OpProcFactory.getLateralViewJoinProc());
        opRules.put(new RuleRegExp("R10", PTFOperator.getOperatorName() + "%"), OpProcFactory.getPTFProc());
        opRules.put(new RuleRegExp("R11", FilterOperator.getOperatorName() + "%"), OpProcFactory.getFilterProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(OpProcFactory.getDefaultProc(), opRules, lCtx);
        LevelOrderWalker ogw = new LevelOrderWalker(disp, 2);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        LOG.debug("Time taken for lineage transform={}", (Object)(System.currentTimeMillis() - sTime));
        return pctx;
    }

    static enum LineageInfoFilter {
        CREATE_TABLE(parseContext -> parseContext.getCreateTable() != null),
        CREATE_TABLE_AS_SELECT(parseContext -> parseContext.getQueryProperties().isCTAS()),
        CREATE_VIEW(parseContext -> parseContext.getQueryProperties().isView()),
        CREATE_MATERIALIZED_VIEW(parseContext -> parseContext.getQueryProperties().isMaterializedView()),
        LOAD(parseContext -> parseContext.getLoadTableWork() != null && !parseContext.getLoadTableWork().isEmpty()),
        QUERY(parseContext -> parseContext.getQueryProperties().isQuery()),
        ALL(parseContext -> true),
        NONE(parseContext -> false);

        final Predicate<ParseContext> predicate;

        private LineageInfoFilter(Predicate<ParseContext> predicate) {
            this.predicate = predicate;
        }
    }
}

